package com.finconsgroup.itserr.marketplace.event.dm.repository;

import com.finconsgroup.itserr.marketplace.event.dm.entity.EventEntity;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.stereotype.Repository;

import java.util.Optional;
import java.util.UUID;

/**
 * {@link EventRepository} repository.
 */
@Repository
public interface EventRepository extends JpaRepository<EventEntity, UUID> {

    /**
     * Retrieves a specific event entity based on the provided author ID and event ID.
     *
     * @param maintainerId the unique identifier of the user to who created the event
     * @param eventId      the unique identifier of the event to be retrieved
     * @return an {@link Optional} containing the matching {@link EventEntity} if found, or an empty {@link Optional} if no match exists
     */
    Optional<EventEntity> findByMaintainerIdAndId(
            UUID maintainerId,
            UUID eventId);

}
