package com.finconsgroup.itserr.marketplace.event.dm.repository;

import com.finconsgroup.itserr.marketplace.event.dm.entity.ProgramSubscribedParticipantEntity;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.stereotype.Repository;

import java.util.Optional;
import java.util.UUID;

/**
 * {@link ProgramSubscribedParticipantRepository} repository.
 */
@Repository
public interface ProgramSubscribedParticipantRepository extends JpaRepository<ProgramSubscribedParticipantEntity, UUID> {

    /**
     * checks if a user is already subscribed to a program
     *
     * @param userId    the unique identifier of a user
     * @param programId the unique identifier of a program
     */
    boolean existsByUserIdAndProgramId(UUID userId, UUID programId);

    /**
     * Retrieves the subscribed participant entry by userId and programId
     *
     * @param userId    the unique identifier of a user
     * @param programId the unique identifier of a program
     */
    Optional<ProgramSubscribedParticipantEntity> findByUserIdAndProgramId(UUID userId, UUID programId);
}
