package com.finconsgroup.itserr.marketplace.event.dm.mapper;

import com.finconsgroup.itserr.marketplace.event.dm.entity.ArchivedEventConductorEntity;
import com.finconsgroup.itserr.marketplace.event.dm.entity.ArchivedEventEntity;
import com.finconsgroup.itserr.marketplace.event.dm.entity.ArchivedProgramConductorEntity;
import com.finconsgroup.itserr.marketplace.event.dm.entity.ArchivedProgramEntity;
import com.finconsgroup.itserr.marketplace.event.dm.entity.ArchivedProgramSubscribedParticipantEntity;
import com.finconsgroup.itserr.marketplace.event.dm.entity.ArchivedScheduleEntity;
import com.finconsgroup.itserr.marketplace.event.dm.entity.ArchivedSubscribedParticipantEntity;
import com.finconsgroup.itserr.marketplace.event.dm.entity.EventConductorEntity;
import com.finconsgroup.itserr.marketplace.event.dm.entity.EventEntity;
import com.finconsgroup.itserr.marketplace.event.dm.entity.ProgramConductorEntity;
import com.finconsgroup.itserr.marketplace.event.dm.entity.ProgramEntity;
import com.finconsgroup.itserr.marketplace.event.dm.entity.ProgramSubscribedParticipantEntity;
import com.finconsgroup.itserr.marketplace.event.dm.entity.ScheduleEntity;
import com.finconsgroup.itserr.marketplace.event.dm.entity.SubscribedParticipantEntity;
import com.finconsgroup.itserr.marketplace.event.dm.model.InstitutionalPageModel;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.processing.Generated;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Generated(
    value = "org.mapstruct.ap.MappingProcessor",
    date = "2026-01-30T09:43:55+0000",
    comments = "version: 1.6.3, compiler: javac, environment: Java 21.0.9 (Eclipse Adoptium)"
)
@Component
public class ArchivedEventMapperImpl implements ArchivedEventMapper {

    @Autowired
    private ArchivedSubscribedParticipantMapper archivedSubscribedParticipantMapper;
    @Autowired
    private ArchivedProgramConductorMapper archivedProgramConductorMapper;
    @Autowired
    private ArchivedProgramSubscribedParticipantMapper archivedProgramSubscribedParticipantMapper;

    @Override
    public ArchivedEventEntity toArchivedEntity(EventEntity src) {
        if ( src == null ) {
            return null;
        }

        ArchivedEventEntity.ArchivedEventEntityBuilder<?, ?> archivedEventEntity = ArchivedEventEntity.builder();

        archivedEventEntity.id( src.getId() );
        archivedEventEntity.title( src.getTitle() );
        archivedEventEntity.eventPlannerId( src.getEventPlannerId() );
        archivedEventEntity.eventLink( src.getEventLink() );
        archivedEventEntity.eventType( src.getEventType() );
        archivedEventEntity.content( src.getContent() );
        archivedEventEntity.subscribedParticipantsCount( src.getSubscribedParticipantsCount() );
        List<String> list = src.getTags();
        if ( list != null ) {
            archivedEventEntity.tags( new ArrayList<String>( list ) );
        }
        List<InstitutionalPageModel> list1 = src.getInstitutionalPages();
        if ( list1 != null ) {
            archivedEventEntity.institutionalPages( new ArrayList<InstitutionalPageModel>( list1 ) );
        }
        archivedEventEntity.imageId( src.getImageId() );
        archivedEventEntity.imageUrl( src.getImageUrl() );
        archivedEventEntity.timezone( src.getTimezone() );
        archivedEventEntity.startDate( src.getStartDate() );
        archivedEventEntity.endDate( src.getEndDate() );
        archivedEventEntity.maintainerId( src.getMaintainerId() );
        archivedEventEntity.creationTime( src.getCreationTime() );
        archivedEventEntity.updateTime( src.getUpdateTime() );
        archivedEventEntity.version( src.getVersion() );
        archivedEventEntity.eventConductors( eventConductorEntityListToArchivedEventConductorEntityList( src.getEventConductors() ) );
        archivedEventEntity.schedules( scheduleEntityListToArchivedScheduleEntityList( src.getSchedules() ) );
        archivedEventEntity.subscribedParticipants( subscribedParticipantEntityListToArchivedSubscribedParticipantEntityList( src.getSubscribedParticipants() ) );

        return archivedEventEntity.build();
    }

    protected ArchivedEventConductorEntity eventConductorEntityToArchivedEventConductorEntity(EventConductorEntity eventConductorEntity) {
        if ( eventConductorEntity == null ) {
            return null;
        }

        ArchivedEventConductorEntity.ArchivedEventConductorEntityBuilder<?, ?> archivedEventConductorEntity = ArchivedEventConductorEntity.builder();

        archivedEventConductorEntity.id( eventConductorEntity.getId() );
        archivedEventConductorEntity.firstName( eventConductorEntity.getFirstName() );
        archivedEventConductorEntity.lastName( eventConductorEntity.getLastName() );
        archivedEventConductorEntity.email( eventConductorEntity.getEmail() );
        archivedEventConductorEntity.orcid( eventConductorEntity.getOrcid() );
        archivedEventConductorEntity.creationTime( eventConductorEntity.getCreationTime() );
        archivedEventConductorEntity.updateTime( eventConductorEntity.getUpdateTime() );
        archivedEventConductorEntity.version( eventConductorEntity.getVersion() );
        archivedEventConductorEntity.conductorOrder( eventConductorEntity.getConductorOrder() );

        return archivedEventConductorEntity.build();
    }

    protected List<ArchivedEventConductorEntity> eventConductorEntityListToArchivedEventConductorEntityList(List<EventConductorEntity> list) {
        if ( list == null ) {
            return null;
        }

        List<ArchivedEventConductorEntity> list1 = new ArrayList<ArchivedEventConductorEntity>( list.size() );
        for ( EventConductorEntity eventConductorEntity : list ) {
            list1.add( eventConductorEntityToArchivedEventConductorEntity( eventConductorEntity ) );
        }

        return list1;
    }

    protected List<ArchivedProgramSubscribedParticipantEntity> programSubscribedParticipantEntityListToArchivedProgramSubscribedParticipantEntityList(List<ProgramSubscribedParticipantEntity> list) {
        if ( list == null ) {
            return null;
        }

        List<ArchivedProgramSubscribedParticipantEntity> list1 = new ArrayList<ArchivedProgramSubscribedParticipantEntity>( list.size() );
        for ( ProgramSubscribedParticipantEntity programSubscribedParticipantEntity : list ) {
            list1.add( archivedProgramSubscribedParticipantMapper.toArchivedProgramSubscribedParticipantEntity( programSubscribedParticipantEntity ) );
        }

        return list1;
    }

    protected List<ArchivedProgramConductorEntity> programConductorEntityListToArchivedProgramConductorEntityList(List<ProgramConductorEntity> list) {
        if ( list == null ) {
            return null;
        }

        List<ArchivedProgramConductorEntity> list1 = new ArrayList<ArchivedProgramConductorEntity>( list.size() );
        for ( ProgramConductorEntity programConductorEntity : list ) {
            list1.add( archivedProgramConductorMapper.toArchivedEntity( programConductorEntity ) );
        }

        return list1;
    }

    protected ArchivedProgramEntity programEntityToArchivedProgramEntity(ProgramEntity programEntity) {
        if ( programEntity == null ) {
            return null;
        }

        ArchivedProgramEntity.ArchivedProgramEntityBuilder<?, ?> archivedProgramEntity = ArchivedProgramEntity.builder();

        archivedProgramEntity.id( programEntity.getId() );
        archivedProgramEntity.title( programEntity.getTitle() );
        archivedProgramEntity.description( programEntity.getDescription() );
        archivedProgramEntity.programLink( programEntity.getProgramLink() );
        archivedProgramEntity.place( programEntity.getPlace() );
        archivedProgramEntity.street( programEntity.getStreet() );
        archivedProgramEntity.houseNumber( programEntity.getHouseNumber() );
        archivedProgramEntity.startTime( programEntity.getStartTime() );
        archivedProgramEntity.endTime( programEntity.getEndTime() );
        archivedProgramEntity.maxParticipants( programEntity.getMaxParticipants() );
        archivedProgramEntity.subscribedParticipantsCount( programEntity.getSubscribedParticipantsCount() );
        archivedProgramEntity.subscribedParticipants( programSubscribedParticipantEntityListToArchivedProgramSubscribedParticipantEntityList( programEntity.getSubscribedParticipants() ) );
        archivedProgramEntity.programConductors( programConductorEntityListToArchivedProgramConductorEntityList( programEntity.getProgramConductors() ) );
        archivedProgramEntity.creationTime( programEntity.getCreationTime() );
        archivedProgramEntity.updateTime( programEntity.getUpdateTime() );
        archivedProgramEntity.version( programEntity.getVersion() );
        archivedProgramEntity.programOrder( programEntity.getProgramOrder() );

        return archivedProgramEntity.build();
    }

    protected List<ArchivedProgramEntity> programEntityListToArchivedProgramEntityList(List<ProgramEntity> list) {
        if ( list == null ) {
            return null;
        }

        List<ArchivedProgramEntity> list1 = new ArrayList<ArchivedProgramEntity>( list.size() );
        for ( ProgramEntity programEntity : list ) {
            list1.add( programEntityToArchivedProgramEntity( programEntity ) );
        }

        return list1;
    }

    protected ArchivedScheduleEntity scheduleEntityToArchivedScheduleEntity(ScheduleEntity scheduleEntity) {
        if ( scheduleEntity == null ) {
            return null;
        }

        ArchivedScheduleEntity.ArchivedScheduleEntityBuilder<?, ?> archivedScheduleEntity = ArchivedScheduleEntity.builder();

        archivedScheduleEntity.id( scheduleEntity.getId() );
        archivedScheduleEntity.title( scheduleEntity.getTitle() );
        archivedScheduleEntity.description( scheduleEntity.getDescription() );
        archivedScheduleEntity.startDate( scheduleEntity.getStartDate() );
        archivedScheduleEntity.startTime( scheduleEntity.getStartTime() );
        archivedScheduleEntity.endTime( scheduleEntity.getEndTime() );
        archivedScheduleEntity.locationCity( scheduleEntity.getLocationCity() );
        archivedScheduleEntity.locationRegion( scheduleEntity.getLocationRegion() );
        archivedScheduleEntity.locationCountry( scheduleEntity.getLocationCountry() );
        archivedScheduleEntity.locationZipCode( scheduleEntity.getLocationZipCode() );
        archivedScheduleEntity.creationTime( scheduleEntity.getCreationTime() );
        archivedScheduleEntity.updateTime( scheduleEntity.getUpdateTime() );
        archivedScheduleEntity.version( scheduleEntity.getVersion() );
        archivedScheduleEntity.scheduleOrder( scheduleEntity.getScheduleOrder() );
        archivedScheduleEntity.programs( programEntityListToArchivedProgramEntityList( scheduleEntity.getPrograms() ) );

        return archivedScheduleEntity.build();
    }

    protected List<ArchivedScheduleEntity> scheduleEntityListToArchivedScheduleEntityList(List<ScheduleEntity> list) {
        if ( list == null ) {
            return null;
        }

        List<ArchivedScheduleEntity> list1 = new ArrayList<ArchivedScheduleEntity>( list.size() );
        for ( ScheduleEntity scheduleEntity : list ) {
            list1.add( scheduleEntityToArchivedScheduleEntity( scheduleEntity ) );
        }

        return list1;
    }

    protected List<ArchivedSubscribedParticipantEntity> subscribedParticipantEntityListToArchivedSubscribedParticipantEntityList(List<SubscribedParticipantEntity> list) {
        if ( list == null ) {
            return null;
        }

        List<ArchivedSubscribedParticipantEntity> list1 = new ArrayList<ArchivedSubscribedParticipantEntity>( list.size() );
        for ( SubscribedParticipantEntity subscribedParticipantEntity : list ) {
            list1.add( archivedSubscribedParticipantMapper.toArchivedSubscribedParticipantEntity( subscribedParticipantEntity ) );
        }

        return list1;
    }
}
