/*
 * Decompiled with CFR 0.152.
 */
package com.finconsgroup.itserr.marketplace.event.dm.service.impl;

import com.finconsgroup.itserr.marketplace.core.web.exception.WP2DuplicateResourceException;
import com.finconsgroup.itserr.marketplace.core.web.exception.WP2ResourceNotFoundException;
import com.finconsgroup.itserr.marketplace.event.dm.dto.InputProgramSubscribedParticipantDto;
import com.finconsgroup.itserr.marketplace.event.dm.dto.OutputEventDto;
import com.finconsgroup.itserr.marketplace.event.dm.entity.ArchivedProgramEntity;
import com.finconsgroup.itserr.marketplace.event.dm.entity.ArchivedProgramSubscribedParticipantEntity;
import com.finconsgroup.itserr.marketplace.event.dm.entity.ProgramEntity;
import com.finconsgroup.itserr.marketplace.event.dm.entity.ProgramSubscribedParticipantEntity;
import com.finconsgroup.itserr.marketplace.event.dm.exception.WP2ProgramCapacityExceededException;
import com.finconsgroup.itserr.marketplace.event.dm.mapper.ArchivedProgramSubscribedParticipantMapper;
import com.finconsgroup.itserr.marketplace.event.dm.repository.ArchivedProgramSubscribedParticipantRepository;
import com.finconsgroup.itserr.marketplace.event.dm.repository.ProgramRepository;
import com.finconsgroup.itserr.marketplace.event.dm.repository.ProgramSubscribedParticipantRepository;
import com.finconsgroup.itserr.marketplace.event.dm.repository.SubscribedParticipantRepository;
import com.finconsgroup.itserr.marketplace.event.dm.service.EventService;
import com.finconsgroup.itserr.marketplace.event.dm.service.ProgramService;
import java.util.UUID;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.lang.NonNull;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@Service
public class DefaultProgramService
implements ProgramService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DefaultProgramService.class);
    private static final String EVENT_PROGRAM_BUSINESS_KEY = "{eventId: %s, programId: %s}";
    private static final String USER_PROGRAM_BUSINESS_KEY = "{userId: %s, programId: %s}";
    private final EventService eventService;
    private final SubscribedParticipantRepository subscribedParticipantRepository;
    private final ProgramRepository programRepository;
    private final ProgramSubscribedParticipantRepository programSubscribedParticipantRepository;
    private final ArchivedProgramSubscribedParticipantRepository archivedProgramSubscribedParticipantRepository;
    private final ArchivedProgramSubscribedParticipantMapper archivedProgramSubscribedParticipantMapper;

    @NonNull
    @Transactional(propagation=Propagation.REQUIRED, rollbackFor={Exception.class})
    public OutputEventDto register(@NonNull UUID userId, @NonNull UUID eventId, @NonNull UUID programId, @NonNull InputProgramSubscribedParticipantDto inputProgramSubscribedParticipantDto) {
        ProgramEntity existingProgramEntity = this.findByIdAndEventIdOrThrow(programId, eventId);
        if (this.programSubscribedParticipantRepository.existsByUserIdAndProgramId(userId, programId)) {
            throw new WP2DuplicateResourceException(USER_PROGRAM_BUSINESS_KEY.formatted(userId, programId));
        }
        if (!inputProgramSubscribedParticipantDto.getRemoteParticipation().booleanValue() && !existingProgramEntity.hasAvailableCapacity()) {
            throw new WP2ProgramCapacityExceededException(programId, existingProgramEntity.getMaxParticipants());
        }
        ProgramSubscribedParticipantEntity programSubscribedParticipantEntity = ProgramSubscribedParticipantEntity.builder().userId(userId).programId(programId).program(existingProgramEntity).remoteParticipation(inputProgramSubscribedParticipantDto.getRemoteParticipation()).participantOrder((long)existingProgramEntity.getSubscribedParticipantsCount().intValue()).build();
        this.programSubscribedParticipantRepository.saveAndFlush((Object)programSubscribedParticipantEntity);
        if (!inputProgramSubscribedParticipantDto.getRemoteParticipation().booleanValue()) {
            existingProgramEntity.incrementParticipants();
            this.programRepository.saveAndFlush((Object)existingProgramEntity);
        }
        if (!this.subscribedParticipantRepository.existsByUserIdAndEventId(userId, eventId)) {
            return this.eventService.register(userId, eventId);
        }
        OutputEventDto outputEventDto = this.eventService.getById(eventId);
        this.eventService.extractSubscribedParticipantProgramDetails(outputEventDto);
        outputEventDto.setSubscribed(Boolean.valueOf(true));
        return outputEventDto;
    }

    @NonNull
    @Transactional(propagation=Propagation.REQUIRED, rollbackFor={Exception.class})
    public OutputEventDto unregister(@NonNull UUID userId, @NonNull UUID eventId, @NonNull UUID programId) {
        ProgramEntity existingProgramEntity = this.findByIdAndEventIdOrThrow(programId, eventId);
        ProgramSubscribedParticipantEntity programSubscribedParticipantEntity = (ProgramSubscribedParticipantEntity)this.programSubscribedParticipantRepository.findByUserIdAndProgramId(userId, programId).orElseThrow(() -> new WP2ResourceNotFoundException(USER_PROGRAM_BUSINESS_KEY.formatted(userId, programId)));
        this.programSubscribedParticipantRepository.delete((Object)programSubscribedParticipantEntity);
        ArchivedProgramSubscribedParticipantEntity archivedProgramSubscribedParticipantEntity = this.archivedProgramSubscribedParticipantMapper.toArchivedProgramSubscribedParticipantEntity(programSubscribedParticipantEntity);
        archivedProgramSubscribedParticipantEntity.setProgram(((ArchivedProgramEntity.ArchivedProgramEntityBuilder)ArchivedProgramEntity.builder().id(programId)).build());
        this.archivedProgramSubscribedParticipantRepository.save((Object)archivedProgramSubscribedParticipantEntity);
        if (!programSubscribedParticipantEntity.getRemoteParticipation().booleanValue()) {
            existingProgramEntity.decrementParticipants();
            this.programRepository.saveAndFlush((Object)existingProgramEntity);
        }
        this.programRepository.flush();
        OutputEventDto outputEventDto = this.eventService.getById(eventId);
        this.eventService.extractSubscribedParticipantProgramDetails(outputEventDto);
        outputEventDto.setSubscribed(Boolean.valueOf(true));
        return outputEventDto;
    }

    private ProgramEntity findByIdAndEventIdOrThrow(@NonNull UUID programId, @NonNull UUID eventId) {
        return (ProgramEntity)this.programRepository.findByIdAndScheduleEventId(programId, eventId).orElseThrow(() -> new WP2ResourceNotFoundException(EVENT_PROGRAM_BUSINESS_KEY.formatted(eventId, programId)));
    }

    @Generated
    public DefaultProgramService(EventService eventService, SubscribedParticipantRepository subscribedParticipantRepository, ProgramRepository programRepository, ProgramSubscribedParticipantRepository programSubscribedParticipantRepository, ArchivedProgramSubscribedParticipantRepository archivedProgramSubscribedParticipantRepository, ArchivedProgramSubscribedParticipantMapper archivedProgramSubscribedParticipantMapper) {
        this.eventService = eventService;
        this.subscribedParticipantRepository = subscribedParticipantRepository;
        this.programRepository = programRepository;
        this.programSubscribedParticipantRepository = programSubscribedParticipantRepository;
        this.archivedProgramSubscribedParticipantRepository = archivedProgramSubscribedParticipantRepository;
        this.archivedProgramSubscribedParticipantMapper = archivedProgramSubscribedParticipantMapper;
    }
}

