/*
 * Decompiled with CFR 0.152.
 */
package com.finconsgroup.itserr.marketplace.event.dm.entity;

import com.finconsgroup.itserr.marketplace.core.entity.AbstractUUIDEntity;
import com.finconsgroup.itserr.marketplace.event.dm.entity.ArchivedProgramConductorEntity;
import com.finconsgroup.itserr.marketplace.event.dm.entity.ArchivedProgramEntity;
import com.finconsgroup.itserr.marketplace.event.dm.entity.ArchivedProgramSubscribedParticipantEntity;
import jakarta.persistence.CascadeType;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.FetchType;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.OneToMany;
import jakarta.persistence.Table;
import java.time.Instant;
import java.time.LocalTime;
import java.util.List;
import lombok.Generated;

@Entity
@Table(name="archived_program")
public class ArchivedProgramEntity
extends AbstractUUIDEntity {
    @Column(name="title", nullable=false, length=255)
    private String title;
    @Column(name="description", length=255)
    private String description;
    @Column(name="program_link", length=500)
    private String programLink;
    @Column(name="place", length=255)
    private String place;
    @Column(name="street", length=255)
    private String street;
    @Column(name="house_number", length=100)
    private String houseNumber;
    @Column(name="start_time", nullable=false)
    private LocalTime startTime;
    @Column(name="end_time", nullable=false)
    private LocalTime endTime;
    @Column(name="max_participants")
    private Integer maxParticipants;
    @Column(name="subscribed_participants")
    private Integer subscribedParticipantsCount;
    @OneToMany(fetch=FetchType.LAZY, cascade={CascadeType.ALL}, orphanRemoval=true, mappedBy="program")
    private List<ArchivedProgramSubscribedParticipantEntity> subscribedParticipants;
    @OneToMany(fetch=FetchType.LAZY, cascade={CascadeType.ALL}, orphanRemoval=true)
    @JoinColumn(name="program_id", nullable=false, updatable=false)
    private List<ArchivedProgramConductorEntity> programConductors;
    @Column(name="creation_time", nullable=false)
    private Instant creationTime;
    @Column(name="update_time", nullable=false)
    private Instant updateTime;
    @Column(name="version", nullable=false)
    private long version;
    @Column(name="program_order", nullable=false)
    private long programOrder;

    public void prePersist() {
        super.prePersist();
        Instant now = Instant.now();
        if (this.creationTime == null) {
            this.creationTime = now;
        }
        if (this.updateTime == null) {
            this.updateTime = now;
        }
    }

    @Generated
    protected ArchivedProgramEntity(ArchivedProgramEntityBuilder<?, ?> b) {
        super(b);
        this.title = b.title;
        this.description = b.description;
        this.programLink = b.programLink;
        this.place = b.place;
        this.street = b.street;
        this.houseNumber = b.houseNumber;
        this.startTime = b.startTime;
        this.endTime = b.endTime;
        this.maxParticipants = b.maxParticipants;
        this.subscribedParticipantsCount = b.subscribedParticipantsCount;
        this.subscribedParticipants = b.subscribedParticipants;
        this.programConductors = b.programConductors;
        this.creationTime = b.creationTime;
        this.updateTime = b.updateTime;
        this.version = b.version;
        this.programOrder = b.programOrder;
    }

    @Generated
    public static ArchivedProgramEntityBuilder<?, ?> builder() {
        return new ArchivedProgramEntityBuilderImpl();
    }

    @Generated
    public String getTitle() {
        return this.title;
    }

    @Generated
    public String getDescription() {
        return this.description;
    }

    @Generated
    public String getProgramLink() {
        return this.programLink;
    }

    @Generated
    public String getPlace() {
        return this.place;
    }

    @Generated
    public String getStreet() {
        return this.street;
    }

    @Generated
    public String getHouseNumber() {
        return this.houseNumber;
    }

    @Generated
    public LocalTime getStartTime() {
        return this.startTime;
    }

    @Generated
    public LocalTime getEndTime() {
        return this.endTime;
    }

    @Generated
    public Integer getMaxParticipants() {
        return this.maxParticipants;
    }

    @Generated
    public Integer getSubscribedParticipantsCount() {
        return this.subscribedParticipantsCount;
    }

    @Generated
    public List<ArchivedProgramSubscribedParticipantEntity> getSubscribedParticipants() {
        return this.subscribedParticipants;
    }

    @Generated
    public List<ArchivedProgramConductorEntity> getProgramConductors() {
        return this.programConductors;
    }

    @Generated
    public Instant getCreationTime() {
        return this.creationTime;
    }

    @Generated
    public Instant getUpdateTime() {
        return this.updateTime;
    }

    @Generated
    public long getVersion() {
        return this.version;
    }

    @Generated
    public long getProgramOrder() {
        return this.programOrder;
    }

    @Generated
    public void setTitle(String title) {
        this.title = title;
    }

    @Generated
    public void setDescription(String description) {
        this.description = description;
    }

    @Generated
    public void setProgramLink(String programLink) {
        this.programLink = programLink;
    }

    @Generated
    public void setPlace(String place) {
        this.place = place;
    }

    @Generated
    public void setStreet(String street) {
        this.street = street;
    }

    @Generated
    public void setHouseNumber(String houseNumber) {
        this.houseNumber = houseNumber;
    }

    @Generated
    public void setStartTime(LocalTime startTime) {
        this.startTime = startTime;
    }

    @Generated
    public void setEndTime(LocalTime endTime) {
        this.endTime = endTime;
    }

    @Generated
    public void setMaxParticipants(Integer maxParticipants) {
        this.maxParticipants = maxParticipants;
    }

    @Generated
    public void setSubscribedParticipantsCount(Integer subscribedParticipantsCount) {
        this.subscribedParticipantsCount = subscribedParticipantsCount;
    }

    @Generated
    public void setSubscribedParticipants(List<ArchivedProgramSubscribedParticipantEntity> subscribedParticipants) {
        this.subscribedParticipants = subscribedParticipants;
    }

    @Generated
    public void setProgramConductors(List<ArchivedProgramConductorEntity> programConductors) {
        this.programConductors = programConductors;
    }

    @Generated
    public void setCreationTime(Instant creationTime) {
        this.creationTime = creationTime;
    }

    @Generated
    public void setUpdateTime(Instant updateTime) {
        this.updateTime = updateTime;
    }

    @Generated
    public void setVersion(long version) {
        this.version = version;
    }

    @Generated
    public void setProgramOrder(long programOrder) {
        this.programOrder = programOrder;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ArchivedProgramEntity)) {
            return false;
        }
        ArchivedProgramEntity other = (ArchivedProgramEntity)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        if (this.getVersion() != other.getVersion()) {
            return false;
        }
        if (this.getProgramOrder() != other.getProgramOrder()) {
            return false;
        }
        Integer this$maxParticipants = this.getMaxParticipants();
        Integer other$maxParticipants = other.getMaxParticipants();
        if (this$maxParticipants == null ? other$maxParticipants != null : !((Object)this$maxParticipants).equals(other$maxParticipants)) {
            return false;
        }
        Integer this$subscribedParticipantsCount = this.getSubscribedParticipantsCount();
        Integer other$subscribedParticipantsCount = other.getSubscribedParticipantsCount();
        if (this$subscribedParticipantsCount == null ? other$subscribedParticipantsCount != null : !((Object)this$subscribedParticipantsCount).equals(other$subscribedParticipantsCount)) {
            return false;
        }
        String this$title = this.getTitle();
        String other$title = other.getTitle();
        if (this$title == null ? other$title != null : !this$title.equals(other$title)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
            return false;
        }
        String this$programLink = this.getProgramLink();
        String other$programLink = other.getProgramLink();
        if (this$programLink == null ? other$programLink != null : !this$programLink.equals(other$programLink)) {
            return false;
        }
        String this$place = this.getPlace();
        String other$place = other.getPlace();
        if (this$place == null ? other$place != null : !this$place.equals(other$place)) {
            return false;
        }
        String this$street = this.getStreet();
        String other$street = other.getStreet();
        if (this$street == null ? other$street != null : !this$street.equals(other$street)) {
            return false;
        }
        String this$houseNumber = this.getHouseNumber();
        String other$houseNumber = other.getHouseNumber();
        if (this$houseNumber == null ? other$houseNumber != null : !this$houseNumber.equals(other$houseNumber)) {
            return false;
        }
        LocalTime this$startTime = this.getStartTime();
        LocalTime other$startTime = other.getStartTime();
        if (this$startTime == null ? other$startTime != null : !((Object)this$startTime).equals(other$startTime)) {
            return false;
        }
        LocalTime this$endTime = this.getEndTime();
        LocalTime other$endTime = other.getEndTime();
        if (this$endTime == null ? other$endTime != null : !((Object)this$endTime).equals(other$endTime)) {
            return false;
        }
        List this$subscribedParticipants = this.getSubscribedParticipants();
        List other$subscribedParticipants = other.getSubscribedParticipants();
        if (this$subscribedParticipants == null ? other$subscribedParticipants != null : !((Object)this$subscribedParticipants).equals(other$subscribedParticipants)) {
            return false;
        }
        List this$programConductors = this.getProgramConductors();
        List other$programConductors = other.getProgramConductors();
        if (this$programConductors == null ? other$programConductors != null : !((Object)this$programConductors).equals(other$programConductors)) {
            return false;
        }
        Instant this$creationTime = this.getCreationTime();
        Instant other$creationTime = other.getCreationTime();
        if (this$creationTime == null ? other$creationTime != null : !((Object)this$creationTime).equals(other$creationTime)) {
            return false;
        }
        Instant this$updateTime = this.getUpdateTime();
        Instant other$updateTime = other.getUpdateTime();
        return !(this$updateTime == null ? other$updateTime != null : !((Object)this$updateTime).equals(other$updateTime));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ArchivedProgramEntity;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        long $version = this.getVersion();
        result = result * 59 + (int)($version >>> 32 ^ $version);
        long $programOrder = this.getProgramOrder();
        result = result * 59 + (int)($programOrder >>> 32 ^ $programOrder);
        Integer $maxParticipants = this.getMaxParticipants();
        result = result * 59 + ($maxParticipants == null ? 43 : ((Object)$maxParticipants).hashCode());
        Integer $subscribedParticipantsCount = this.getSubscribedParticipantsCount();
        result = result * 59 + ($subscribedParticipantsCount == null ? 43 : ((Object)$subscribedParticipantsCount).hashCode());
        String $title = this.getTitle();
        result = result * 59 + ($title == null ? 43 : $title.hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        String $programLink = this.getProgramLink();
        result = result * 59 + ($programLink == null ? 43 : $programLink.hashCode());
        String $place = this.getPlace();
        result = result * 59 + ($place == null ? 43 : $place.hashCode());
        String $street = this.getStreet();
        result = result * 59 + ($street == null ? 43 : $street.hashCode());
        String $houseNumber = this.getHouseNumber();
        result = result * 59 + ($houseNumber == null ? 43 : $houseNumber.hashCode());
        LocalTime $startTime = this.getStartTime();
        result = result * 59 + ($startTime == null ? 43 : ((Object)$startTime).hashCode());
        LocalTime $endTime = this.getEndTime();
        result = result * 59 + ($endTime == null ? 43 : ((Object)$endTime).hashCode());
        List $subscribedParticipants = this.getSubscribedParticipants();
        result = result * 59 + ($subscribedParticipants == null ? 43 : ((Object)$subscribedParticipants).hashCode());
        List $programConductors = this.getProgramConductors();
        result = result * 59 + ($programConductors == null ? 43 : ((Object)$programConductors).hashCode());
        Instant $creationTime = this.getCreationTime();
        result = result * 59 + ($creationTime == null ? 43 : ((Object)$creationTime).hashCode());
        Instant $updateTime = this.getUpdateTime();
        result = result * 59 + ($updateTime == null ? 43 : ((Object)$updateTime).hashCode());
        return result;
    }

    @Generated
    public ArchivedProgramEntity() {
    }
}

