package com.finconsgroup.itserr.marketplace.event.dm.exception;

import com.finconsgroup.itserr.marketplace.core.web.exception.WP2ValidationException;

import java.util.UUID;

public class WP2ProgramCapacityExceededException extends WP2ValidationException {

    public static final String PROGRAM_CAPACITY_EXCEEDED_EXCEPTION_MESSAGE = "Program with ID '%s' has reached its maximum capacity of %d participant";

    public WP2ProgramCapacityExceededException(UUID id, Integer maxParticipants) {
        super(PROGRAM_CAPACITY_EXCEEDED_EXCEPTION_MESSAGE.formatted(id.toString(), maxParticipants));
    }
}
