package com.finconsgroup.itserr.marketplace.event.dm.mapper;

import com.finconsgroup.itserr.marketplace.event.dm.dto.InputEventConductorDto;
import com.finconsgroup.itserr.marketplace.event.dm.dto.OutputEventConductorDto;
import com.finconsgroup.itserr.marketplace.event.dm.entity.EventConductorEntity;
import org.mapstruct.IterableMapping;
import org.mapstruct.Mapper;
import org.mapstruct.Mapping;
import org.mapstruct.MappingTarget;
import org.mapstruct.NullValueMappingStrategy;

@Mapper(config = MapperConfiguration.class)
public interface EventConductorMapper {

    @Mapping(target = "id", ignore = true)
    @Mapping(target = "creationTime", ignore = true)
    @Mapping(target = "updateTime", ignore = true)
    @Mapping(target = "version", ignore = true)
    @Mapping(target = "conductorOrder", ignore = true)
    @Mapping(target = "event", ignore = true)
    @Mapping(target = "eventId", ignore = true)
    EventConductorEntity toEntity(InputEventConductorDto eventConductorDto);

    OutputEventConductorDto toDto(EventConductorEntity entity);

    @Mapping(target = "id", ignore = true)
    @Mapping(target = "creationTime", ignore = true)
    @Mapping(target = "updateTime", ignore = true)
    @Mapping(target = "version", ignore = true)
    @Mapping(target = "conductorOrder", ignore = true)
    @Mapping(target = "event", ignore = true)
    @Mapping(target = "eventId", ignore = true)
    @IterableMapping(nullValueMappingStrategy = NullValueMappingStrategy.RETURN_DEFAULT)
    void updateEntity(InputEventConductorDto dto, @MappingTarget EventConductorEntity entity);

}
