/*
 * Decompiled with CFR 0.152.
 */
package com.finconsgroup.itserr.marketplace.event.dm.entity;

import com.finconsgroup.itserr.marketplace.core.entity.AbstractUUIDEntity;
import com.finconsgroup.itserr.marketplace.event.dm.entity.ProgramEntity;
import com.finconsgroup.itserr.marketplace.event.dm.entity.ProgramSubscribedParticipantEntity;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.PreUpdate;
import jakarta.persistence.Table;
import jakarta.persistence.Version;
import java.time.Instant;
import java.util.UUID;
import lombok.Generated;

@Entity
@Table(name="program_subscribed_participant")
public class ProgramSubscribedParticipantEntity
extends AbstractUUIDEntity {
    @ManyToOne
    @JoinColumn(name="program_id", updatable=false)
    private ProgramEntity program;
    @Column(name="program_id", insertable=false, updatable=false)
    private UUID programId;
    @Column(name="user_id", updatable=false)
    private UUID userId;
    @Column(name="remote_participation", updatable=false)
    private Boolean remoteParticipation;
    @Column(name="creation_time", nullable=false, updatable=false)
    private Instant creationTime;
    @Column(name="update_time", nullable=false)
    private Instant updateTime;
    @Version
    @Column(name="version", nullable=false)
    private long version;
    @Column(name="participant_order", nullable=false)
    private long participantOrder;

    public void prePersist() {
        super.prePersist();
        Instant now = Instant.now();
        if (this.creationTime == null) {
            this.creationTime = now;
        }
        if (this.updateTime == null) {
            this.updateTime = now;
        }
    }

    @PreUpdate
    public void onUpdate() {
        this.updateTime = Instant.now();
    }

    @Generated
    protected ProgramSubscribedParticipantEntity(ProgramSubscribedParticipantEntityBuilder<?, ?> b) {
        super(b);
        this.program = b.program;
        this.programId = b.programId;
        this.userId = b.userId;
        this.remoteParticipation = b.remoteParticipation;
        this.creationTime = b.creationTime;
        this.updateTime = b.updateTime;
        this.version = b.version;
        this.participantOrder = b.participantOrder;
    }

    @Generated
    public static ProgramSubscribedParticipantEntityBuilder<?, ?> builder() {
        return new ProgramSubscribedParticipantEntityBuilderImpl();
    }

    @Generated
    public ProgramEntity getProgram() {
        return this.program;
    }

    @Generated
    public UUID getProgramId() {
        return this.programId;
    }

    @Generated
    public UUID getUserId() {
        return this.userId;
    }

    @Generated
    public Boolean getRemoteParticipation() {
        return this.remoteParticipation;
    }

    @Generated
    public Instant getCreationTime() {
        return this.creationTime;
    }

    @Generated
    public Instant getUpdateTime() {
        return this.updateTime;
    }

    @Generated
    public long getVersion() {
        return this.version;
    }

    @Generated
    public long getParticipantOrder() {
        return this.participantOrder;
    }

    @Generated
    public void setProgram(ProgramEntity program) {
        this.program = program;
    }

    @Generated
    public void setProgramId(UUID programId) {
        this.programId = programId;
    }

    @Generated
    public void setUserId(UUID userId) {
        this.userId = userId;
    }

    @Generated
    public void setRemoteParticipation(Boolean remoteParticipation) {
        this.remoteParticipation = remoteParticipation;
    }

    @Generated
    public void setCreationTime(Instant creationTime) {
        this.creationTime = creationTime;
    }

    @Generated
    public void setUpdateTime(Instant updateTime) {
        this.updateTime = updateTime;
    }

    @Generated
    public void setVersion(long version) {
        this.version = version;
    }

    @Generated
    public void setParticipantOrder(long participantOrder) {
        this.participantOrder = participantOrder;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ProgramSubscribedParticipantEntity)) {
            return false;
        }
        ProgramSubscribedParticipantEntity other = (ProgramSubscribedParticipantEntity)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        if (this.getVersion() != other.getVersion()) {
            return false;
        }
        if (this.getParticipantOrder() != other.getParticipantOrder()) {
            return false;
        }
        Boolean this$remoteParticipation = this.getRemoteParticipation();
        Boolean other$remoteParticipation = other.getRemoteParticipation();
        if (this$remoteParticipation == null ? other$remoteParticipation != null : !((Object)this$remoteParticipation).equals(other$remoteParticipation)) {
            return false;
        }
        ProgramEntity this$program = this.getProgram();
        ProgramEntity other$program = other.getProgram();
        if (this$program == null ? other$program != null : !this$program.equals(other$program)) {
            return false;
        }
        UUID this$programId = this.getProgramId();
        UUID other$programId = other.getProgramId();
        if (this$programId == null ? other$programId != null : !((Object)this$programId).equals(other$programId)) {
            return false;
        }
        UUID this$userId = this.getUserId();
        UUID other$userId = other.getUserId();
        if (this$userId == null ? other$userId != null : !((Object)this$userId).equals(other$userId)) {
            return false;
        }
        Instant this$creationTime = this.getCreationTime();
        Instant other$creationTime = other.getCreationTime();
        if (this$creationTime == null ? other$creationTime != null : !((Object)this$creationTime).equals(other$creationTime)) {
            return false;
        }
        Instant this$updateTime = this.getUpdateTime();
        Instant other$updateTime = other.getUpdateTime();
        return !(this$updateTime == null ? other$updateTime != null : !((Object)this$updateTime).equals(other$updateTime));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ProgramSubscribedParticipantEntity;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        long $version = this.getVersion();
        result = result * 59 + (int)($version >>> 32 ^ $version);
        long $participantOrder = this.getParticipantOrder();
        result = result * 59 + (int)($participantOrder >>> 32 ^ $participantOrder);
        Boolean $remoteParticipation = this.getRemoteParticipation();
        result = result * 59 + ($remoteParticipation == null ? 43 : ((Object)$remoteParticipation).hashCode());
        ProgramEntity $program = this.getProgram();
        result = result * 59 + ($program == null ? 43 : $program.hashCode());
        UUID $programId = this.getProgramId();
        result = result * 59 + ($programId == null ? 43 : ((Object)$programId).hashCode());
        UUID $userId = this.getUserId();
        result = result * 59 + ($userId == null ? 43 : ((Object)$userId).hashCode());
        Instant $creationTime = this.getCreationTime();
        result = result * 59 + ($creationTime == null ? 43 : ((Object)$creationTime).hashCode());
        Instant $updateTime = this.getUpdateTime();
        result = result * 59 + ($updateTime == null ? 43 : ((Object)$updateTime).hashCode());
        return result;
    }

    @Generated
    public ProgramSubscribedParticipantEntity() {
    }
}

