/*
 * Decompiled with CFR 0.152.
 */
package com.finconsgroup.itserr.marketplace.event.dm.dto;

import com.finconsgroup.itserr.marketplace.event.dm.dto.OutputProgramConductorDto;
import com.finconsgroup.itserr.marketplace.event.dm.dto.OutputProgramSubscribedParticipantDto;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotEmpty;
import java.time.LocalTime;
import java.util.List;
import java.util.UUID;
import lombok.Generated;

@Schema(name="OutputProgramDto", description="DTO for program")
public class OutputProgramDto {
    @Schema(description="Unique identifier of the program", example="550e8400-e29b-41d4-a716-446655440000")
    private UUID id;
    @Schema(description="The title of the program", example="Java Webinar")
    private String title;
    @Schema(description="The description of the program", example="Webinar on java new and breaking changes")
    private String description;
    @Schema(description="The link for the program", example="https://meeting.example.com/testProgram123")
    private String programLink;
    @Schema(description="The program conductors")
    @Valid
    @NotEmpty
    private List<OutputProgramConductorDto> programConductors;
    @Schema(description="The place of the program", example="Via Test Street, Floor 2, Room 1")
    private String place;
    @Schema(description="The street details for map", example="can be coordinates or actual value")
    private String street;
    @Schema(description="The house number", example="432b/a")
    private String houseNumber;
    @Schema(description="The maximum number of participants allowed for the program", example="22")
    private Integer maxParticipants;
    @Schema(description="List of subscribed participants")
    private List<OutputProgramSubscribedParticipantDto> subscribedParticipants;
    @Schema(description="The number of participants subscribed for the program", example="10")
    private Integer subscribedParticipantsCount;
    @Schema(description="The start time of the program", example="10:30:00")
    private LocalTime startTime;
    @Schema(description="The end time of the program", example="15:30:00")
    private LocalTime endTime;

    @Generated
    protected OutputProgramDto(OutputProgramDtoBuilder<?, ?> b) {
        this.id = b.id;
        this.title = b.title;
        this.description = b.description;
        this.programLink = b.programLink;
        this.programConductors = b.programConductors;
        this.place = b.place;
        this.street = b.street;
        this.houseNumber = b.houseNumber;
        this.maxParticipants = b.maxParticipants;
        this.subscribedParticipants = b.subscribedParticipants;
        this.subscribedParticipantsCount = b.subscribedParticipantsCount;
        this.startTime = b.startTime;
        this.endTime = b.endTime;
    }

    @Generated
    public static OutputProgramDtoBuilder<?, ?> builder() {
        return new OutputProgramDtoBuilderImpl();
    }

    @Generated
    public UUID getId() {
        return this.id;
    }

    @Generated
    public String getTitle() {
        return this.title;
    }

    @Generated
    public String getDescription() {
        return this.description;
    }

    @Generated
    public String getProgramLink() {
        return this.programLink;
    }

    @Generated
    public List<OutputProgramConductorDto> getProgramConductors() {
        return this.programConductors;
    }

    @Generated
    public String getPlace() {
        return this.place;
    }

    @Generated
    public String getStreet() {
        return this.street;
    }

    @Generated
    public String getHouseNumber() {
        return this.houseNumber;
    }

    @Generated
    public Integer getMaxParticipants() {
        return this.maxParticipants;
    }

    @Generated
    public List<OutputProgramSubscribedParticipantDto> getSubscribedParticipants() {
        return this.subscribedParticipants;
    }

    @Generated
    public Integer getSubscribedParticipantsCount() {
        return this.subscribedParticipantsCount;
    }

    @Generated
    public LocalTime getStartTime() {
        return this.startTime;
    }

    @Generated
    public LocalTime getEndTime() {
        return this.endTime;
    }

    @Generated
    public void setId(UUID id) {
        this.id = id;
    }

    @Generated
    public void setTitle(String title) {
        this.title = title;
    }

    @Generated
    public void setDescription(String description) {
        this.description = description;
    }

    @Generated
    public void setProgramLink(String programLink) {
        this.programLink = programLink;
    }

    @Generated
    public void setProgramConductors(List<OutputProgramConductorDto> programConductors) {
        this.programConductors = programConductors;
    }

    @Generated
    public void setPlace(String place) {
        this.place = place;
    }

    @Generated
    public void setStreet(String street) {
        this.street = street;
    }

    @Generated
    public void setHouseNumber(String houseNumber) {
        this.houseNumber = houseNumber;
    }

    @Generated
    public void setMaxParticipants(Integer maxParticipants) {
        this.maxParticipants = maxParticipants;
    }

    @Generated
    public void setSubscribedParticipants(List<OutputProgramSubscribedParticipantDto> subscribedParticipants) {
        this.subscribedParticipants = subscribedParticipants;
    }

    @Generated
    public void setSubscribedParticipantsCount(Integer subscribedParticipantsCount) {
        this.subscribedParticipantsCount = subscribedParticipantsCount;
    }

    @Generated
    public void setStartTime(LocalTime startTime) {
        this.startTime = startTime;
    }

    @Generated
    public void setEndTime(LocalTime endTime) {
        this.endTime = endTime;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof OutputProgramDto)) {
            return false;
        }
        OutputProgramDto other = (OutputProgramDto)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Integer this$maxParticipants = this.getMaxParticipants();
        Integer other$maxParticipants = other.getMaxParticipants();
        if (this$maxParticipants == null ? other$maxParticipants != null : !((Object)this$maxParticipants).equals(other$maxParticipants)) {
            return false;
        }
        Integer this$subscribedParticipantsCount = this.getSubscribedParticipantsCount();
        Integer other$subscribedParticipantsCount = other.getSubscribedParticipantsCount();
        if (this$subscribedParticipantsCount == null ? other$subscribedParticipantsCount != null : !((Object)this$subscribedParticipantsCount).equals(other$subscribedParticipantsCount)) {
            return false;
        }
        UUID this$id = this.getId();
        UUID other$id = other.getId();
        if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
            return false;
        }
        String this$title = this.getTitle();
        String other$title = other.getTitle();
        if (this$title == null ? other$title != null : !this$title.equals(other$title)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
            return false;
        }
        String this$programLink = this.getProgramLink();
        String other$programLink = other.getProgramLink();
        if (this$programLink == null ? other$programLink != null : !this$programLink.equals(other$programLink)) {
            return false;
        }
        List<OutputProgramConductorDto> this$programConductors = this.getProgramConductors();
        List<OutputProgramConductorDto> other$programConductors = other.getProgramConductors();
        if (this$programConductors == null ? other$programConductors != null : !((Object)this$programConductors).equals(other$programConductors)) {
            return false;
        }
        String this$place = this.getPlace();
        String other$place = other.getPlace();
        if (this$place == null ? other$place != null : !this$place.equals(other$place)) {
            return false;
        }
        String this$street = this.getStreet();
        String other$street = other.getStreet();
        if (this$street == null ? other$street != null : !this$street.equals(other$street)) {
            return false;
        }
        String this$houseNumber = this.getHouseNumber();
        String other$houseNumber = other.getHouseNumber();
        if (this$houseNumber == null ? other$houseNumber != null : !this$houseNumber.equals(other$houseNumber)) {
            return false;
        }
        List<OutputProgramSubscribedParticipantDto> this$subscribedParticipants = this.getSubscribedParticipants();
        List<OutputProgramSubscribedParticipantDto> other$subscribedParticipants = other.getSubscribedParticipants();
        if (this$subscribedParticipants == null ? other$subscribedParticipants != null : !((Object)this$subscribedParticipants).equals(other$subscribedParticipants)) {
            return false;
        }
        LocalTime this$startTime = this.getStartTime();
        LocalTime other$startTime = other.getStartTime();
        if (this$startTime == null ? other$startTime != null : !((Object)this$startTime).equals(other$startTime)) {
            return false;
        }
        LocalTime this$endTime = this.getEndTime();
        LocalTime other$endTime = other.getEndTime();
        return !(this$endTime == null ? other$endTime != null : !((Object)this$endTime).equals(other$endTime));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof OutputProgramDto;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $maxParticipants = this.getMaxParticipants();
        result = result * 59 + ($maxParticipants == null ? 43 : ((Object)$maxParticipants).hashCode());
        Integer $subscribedParticipantsCount = this.getSubscribedParticipantsCount();
        result = result * 59 + ($subscribedParticipantsCount == null ? 43 : ((Object)$subscribedParticipantsCount).hashCode());
        UUID $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        String $title = this.getTitle();
        result = result * 59 + ($title == null ? 43 : $title.hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        String $programLink = this.getProgramLink();
        result = result * 59 + ($programLink == null ? 43 : $programLink.hashCode());
        List<OutputProgramConductorDto> $programConductors = this.getProgramConductors();
        result = result * 59 + ($programConductors == null ? 43 : ((Object)$programConductors).hashCode());
        String $place = this.getPlace();
        result = result * 59 + ($place == null ? 43 : $place.hashCode());
        String $street = this.getStreet();
        result = result * 59 + ($street == null ? 43 : $street.hashCode());
        String $houseNumber = this.getHouseNumber();
        result = result * 59 + ($houseNumber == null ? 43 : $houseNumber.hashCode());
        List<OutputProgramSubscribedParticipantDto> $subscribedParticipants = this.getSubscribedParticipants();
        result = result * 59 + ($subscribedParticipants == null ? 43 : ((Object)$subscribedParticipants).hashCode());
        LocalTime $startTime = this.getStartTime();
        result = result * 59 + ($startTime == null ? 43 : ((Object)$startTime).hashCode());
        LocalTime $endTime = this.getEndTime();
        result = result * 59 + ($endTime == null ? 43 : ((Object)$endTime).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "OutputProgramDto(id=" + String.valueOf(this.getId()) + ", title=" + this.getTitle() + ", description=" + this.getDescription() + ", programLink=" + this.getProgramLink() + ", programConductors=" + String.valueOf(this.getProgramConductors()) + ", place=" + this.getPlace() + ", street=" + this.getStreet() + ", houseNumber=" + this.getHouseNumber() + ", maxParticipants=" + this.getMaxParticipants() + ", subscribedParticipants=" + String.valueOf(this.getSubscribedParticipants()) + ", subscribedParticipantsCount=" + this.getSubscribedParticipantsCount() + ", startTime=" + String.valueOf(this.getStartTime()) + ", endTime=" + String.valueOf(this.getEndTime()) + ")";
    }

    @Generated
    public OutputProgramDto() {
    }

    @Generated
    public OutputProgramDto(UUID id, String title, String description, String programLink, List<OutputProgramConductorDto> programConductors, String place, String street, String houseNumber, Integer maxParticipants, List<OutputProgramSubscribedParticipantDto> subscribedParticipants, Integer subscribedParticipantsCount, LocalTime startTime, LocalTime endTime) {
        this.id = id;
        this.title = title;
        this.description = description;
        this.programLink = programLink;
        this.programConductors = programConductors;
        this.place = place;
        this.street = street;
        this.houseNumber = houseNumber;
        this.maxParticipants = maxParticipants;
        this.subscribedParticipants = subscribedParticipants;
        this.subscribedParticipantsCount = subscribedParticipantsCount;
        this.startTime = startTime;
        this.endTime = endTime;
    }

    @Generated
    public static abstract class OutputProgramDtoBuilder<C extends OutputProgramDto, B extends OutputProgramDtoBuilder<C, B>> {
        @Generated
        private UUID id;
        @Generated
        private String title;
        @Generated
        private String description;
        @Generated
        private String programLink;
        @Generated
        private List<OutputProgramConductorDto> programConductors;
        @Generated
        private String place;
        @Generated
        private String street;
        @Generated
        private String houseNumber;
        @Generated
        private Integer maxParticipants;
        @Generated
        private List<OutputProgramSubscribedParticipantDto> subscribedParticipants;
        @Generated
        private Integer subscribedParticipantsCount;
        @Generated
        private LocalTime startTime;
        @Generated
        private LocalTime endTime;

        @Generated
        public B id(UUID id) {
            this.id = id;
            return this.self();
        }

        @Generated
        public B title(String title) {
            this.title = title;
            return this.self();
        }

        @Generated
        public B description(String description) {
            this.description = description;
            return this.self();
        }

        @Generated
        public B programLink(String programLink) {
            this.programLink = programLink;
            return this.self();
        }

        @Generated
        public B programConductors(List<OutputProgramConductorDto> programConductors) {
            this.programConductors = programConductors;
            return this.self();
        }

        @Generated
        public B place(String place) {
            this.place = place;
            return this.self();
        }

        @Generated
        public B street(String street) {
            this.street = street;
            return this.self();
        }

        @Generated
        public B houseNumber(String houseNumber) {
            this.houseNumber = houseNumber;
            return this.self();
        }

        @Generated
        public B maxParticipants(Integer maxParticipants) {
            this.maxParticipants = maxParticipants;
            return this.self();
        }

        @Generated
        public B subscribedParticipants(List<OutputProgramSubscribedParticipantDto> subscribedParticipants) {
            this.subscribedParticipants = subscribedParticipants;
            return this.self();
        }

        @Generated
        public B subscribedParticipantsCount(Integer subscribedParticipantsCount) {
            this.subscribedParticipantsCount = subscribedParticipantsCount;
            return this.self();
        }

        @Generated
        public B startTime(LocalTime startTime) {
            this.startTime = startTime;
            return this.self();
        }

        @Generated
        public B endTime(LocalTime endTime) {
            this.endTime = endTime;
            return this.self();
        }

        @Generated
        protected abstract B self();

        @Generated
        public abstract C build();

        @Generated
        public String toString() {
            return "OutputProgramDto.OutputProgramDtoBuilder(id=" + String.valueOf(this.id) + ", title=" + this.title + ", description=" + this.description + ", programLink=" + this.programLink + ", programConductors=" + String.valueOf(this.programConductors) + ", place=" + this.place + ", street=" + this.street + ", houseNumber=" + this.houseNumber + ", maxParticipants=" + this.maxParticipants + ", subscribedParticipants=" + String.valueOf(this.subscribedParticipants) + ", subscribedParticipantsCount=" + this.subscribedParticipantsCount + ", startTime=" + String.valueOf(this.startTime) + ", endTime=" + String.valueOf(this.endTime) + ")";
        }
    }

    @Generated
    private static final class OutputProgramDtoBuilderImpl
    extends OutputProgramDtoBuilder<OutputProgramDto, OutputProgramDtoBuilderImpl> {
        @Generated
        private OutputProgramDtoBuilderImpl() {
        }

        @Override
        @Generated
        protected OutputProgramDtoBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public OutputProgramDto build() {
            return new OutputProgramDto(this);
        }
    }
}

