package com.finconsgroup.itserr.marketplace.event.dm.dto;

import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.constraints.NotBlank;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Size;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.experimental.SuperBuilder;

import java.util.UUID;

import static com.finconsgroup.itserr.marketplace.event.dm.util.DomainConstants.MEDIUM_TEXT_LENGTH;

/**
 * Input DTO for image.
 */
@Schema(name = "InputImageDto", description = "DTO for image")
@Data
@SuperBuilder
@NoArgsConstructor
@AllArgsConstructor
public class InputImageDto {

    @Schema(description = "The document ID of the image", example = "fd4d1ff4-16c5-4468-83fc-454881f73134")
    @NotNull
    private UUID id;

    @Schema(description = "Public URL of the image", example = "https://example.com/images/tech-conference-2025.jpg")
    @NotBlank
    @Size(max = MEDIUM_TEXT_LENGTH)
    private String url;
}
