/*
 * Decompiled with CFR 0.152.
 */
package com.finconsgroup.itserr.marketplace.event.dm.dto;

import com.finconsgroup.itserr.marketplace.event.dm.dto.InputLocationDto;
import com.finconsgroup.itserr.marketplace.event.dm.dto.InputProgramDto;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotBlank;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Size;
import java.time.LocalDate;
import java.time.LocalTime;
import java.util.List;
import lombok.Generated;

@Schema(name="InputScheduleDto", description="DTO for schedule")
public class InputScheduleDto {
    @Schema(description="The title of the schedule", example="Day 1")
    @NotBlank
    @Size(max=255)
    private @NotBlank @Size(max=255) String title;
    @Schema(description="The description of the schedule", example="Day 1 of Annual Tech Conference 2025")
    @Size(max=8000)
    private @Size(max=8000) String description;
    @Schema(description="The start date of the schedule", example="2025-06-18")
    @NotNull
    private LocalDate startDate;
    @Schema(description="The start time of the schedule", example="10:30:00")
    @NotNull
    private LocalTime startTime;
    @Schema(description="The end time of the schedule", example="15:30:00")
    @NotNull
    private LocalTime endTime;
    @Schema(description="The location of the schedule")
    @Valid
    private InputLocationDto location;
    @Schema(description="The programs of the schedule")
    @Valid
    private List<InputProgramDto> programs;

    @Generated
    protected InputScheduleDto(InputScheduleDtoBuilder<?, ?> b) {
        this.title = b.title;
        this.description = b.description;
        this.startDate = b.startDate;
        this.startTime = b.startTime;
        this.endTime = b.endTime;
        this.location = b.location;
        this.programs = b.programs;
    }

    @Generated
    public static InputScheduleDtoBuilder<?, ?> builder() {
        return new InputScheduleDtoBuilderImpl();
    }

    @Generated
    public String getTitle() {
        return this.title;
    }

    @Generated
    public String getDescription() {
        return this.description;
    }

    @Generated
    public LocalDate getStartDate() {
        return this.startDate;
    }

    @Generated
    public LocalTime getStartTime() {
        return this.startTime;
    }

    @Generated
    public LocalTime getEndTime() {
        return this.endTime;
    }

    @Generated
    public InputLocationDto getLocation() {
        return this.location;
    }

    @Generated
    public List<InputProgramDto> getPrograms() {
        return this.programs;
    }

    @Generated
    public void setTitle(String title) {
        this.title = title;
    }

    @Generated
    public void setDescription(String description) {
        this.description = description;
    }

    @Generated
    public void setStartDate(LocalDate startDate) {
        this.startDate = startDate;
    }

    @Generated
    public void setStartTime(LocalTime startTime) {
        this.startTime = startTime;
    }

    @Generated
    public void setEndTime(LocalTime endTime) {
        this.endTime = endTime;
    }

    @Generated
    public void setLocation(InputLocationDto location) {
        this.location = location;
    }

    @Generated
    public void setPrograms(List<InputProgramDto> programs) {
        this.programs = programs;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof InputScheduleDto)) {
            return false;
        }
        InputScheduleDto other = (InputScheduleDto)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$title = this.getTitle();
        String other$title = other.getTitle();
        if (this$title == null ? other$title != null : !this$title.equals(other$title)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
            return false;
        }
        LocalDate this$startDate = this.getStartDate();
        LocalDate other$startDate = other.getStartDate();
        if (this$startDate == null ? other$startDate != null : !((Object)this$startDate).equals(other$startDate)) {
            return false;
        }
        LocalTime this$startTime = this.getStartTime();
        LocalTime other$startTime = other.getStartTime();
        if (this$startTime == null ? other$startTime != null : !((Object)this$startTime).equals(other$startTime)) {
            return false;
        }
        LocalTime this$endTime = this.getEndTime();
        LocalTime other$endTime = other.getEndTime();
        if (this$endTime == null ? other$endTime != null : !((Object)this$endTime).equals(other$endTime)) {
            return false;
        }
        InputLocationDto this$location = this.getLocation();
        InputLocationDto other$location = other.getLocation();
        if (this$location == null ? other$location != null : !((Object)this$location).equals(other$location)) {
            return false;
        }
        List<InputProgramDto> this$programs = this.getPrograms();
        List<InputProgramDto> other$programs = other.getPrograms();
        return !(this$programs == null ? other$programs != null : !((Object)this$programs).equals(other$programs));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof InputScheduleDto;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $title = this.getTitle();
        result = result * 59 + ($title == null ? 43 : $title.hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        LocalDate $startDate = this.getStartDate();
        result = result * 59 + ($startDate == null ? 43 : ((Object)$startDate).hashCode());
        LocalTime $startTime = this.getStartTime();
        result = result * 59 + ($startTime == null ? 43 : ((Object)$startTime).hashCode());
        LocalTime $endTime = this.getEndTime();
        result = result * 59 + ($endTime == null ? 43 : ((Object)$endTime).hashCode());
        InputLocationDto $location = this.getLocation();
        result = result * 59 + ($location == null ? 43 : ((Object)$location).hashCode());
        List<InputProgramDto> $programs = this.getPrograms();
        result = result * 59 + ($programs == null ? 43 : ((Object)$programs).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "InputScheduleDto(title=" + this.getTitle() + ", description=" + this.getDescription() + ", startDate=" + String.valueOf(this.getStartDate()) + ", startTime=" + String.valueOf(this.getStartTime()) + ", endTime=" + String.valueOf(this.getEndTime()) + ", location=" + String.valueOf(this.getLocation()) + ", programs=" + String.valueOf(this.getPrograms()) + ")";
    }

    @Generated
    public InputScheduleDto() {
    }

    @Generated
    public InputScheduleDto(String title, String description, LocalDate startDate, LocalTime startTime, LocalTime endTime, InputLocationDto location, List<InputProgramDto> programs) {
        this.title = title;
        this.description = description;
        this.startDate = startDate;
        this.startTime = startTime;
        this.endTime = endTime;
        this.location = location;
        this.programs = programs;
    }

    @Generated
    public static abstract class InputScheduleDtoBuilder<C extends InputScheduleDto, B extends InputScheduleDtoBuilder<C, B>> {
        @Generated
        private String title;
        @Generated
        private String description;
        @Generated
        private LocalDate startDate;
        @Generated
        private LocalTime startTime;
        @Generated
        private LocalTime endTime;
        @Generated
        private InputLocationDto location;
        @Generated
        private List<InputProgramDto> programs;

        @Generated
        public B title(String title) {
            this.title = title;
            return this.self();
        }

        @Generated
        public B description(String description) {
            this.description = description;
            return this.self();
        }

        @Generated
        public B startDate(LocalDate startDate) {
            this.startDate = startDate;
            return this.self();
        }

        @Generated
        public B startTime(LocalTime startTime) {
            this.startTime = startTime;
            return this.self();
        }

        @Generated
        public B endTime(LocalTime endTime) {
            this.endTime = endTime;
            return this.self();
        }

        @Generated
        public B location(InputLocationDto location) {
            this.location = location;
            return this.self();
        }

        @Generated
        public B programs(List<InputProgramDto> programs) {
            this.programs = programs;
            return this.self();
        }

        @Generated
        protected abstract B self();

        @Generated
        public abstract C build();

        @Generated
        public String toString() {
            return "InputScheduleDto.InputScheduleDtoBuilder(title=" + this.title + ", description=" + this.description + ", startDate=" + String.valueOf(this.startDate) + ", startTime=" + String.valueOf(this.startTime) + ", endTime=" + String.valueOf(this.endTime) + ", location=" + String.valueOf(this.location) + ", programs=" + String.valueOf(this.programs) + ")";
        }
    }

    @Generated
    private static final class InputScheduleDtoBuilderImpl
    extends InputScheduleDtoBuilder<InputScheduleDto, InputScheduleDtoBuilderImpl> {
        @Generated
        private InputScheduleDtoBuilderImpl() {
        }

        @Override
        @Generated
        protected InputScheduleDtoBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public InputScheduleDto build() {
            return new InputScheduleDto(this);
        }
    }
}

