/*
 * Decompiled with CFR 0.152.
 */
package com.finconsgroup.itserr.marketplace.event.bs.messaging.impl;

import com.finconsgroup.itserr.marketplace.event.bs.configuration.properties.EventBsConfigurationProperties;
import com.finconsgroup.itserr.marketplace.event.bs.messaging.EventProducer;
import com.finconsgroup.itserr.messaging.dto.MessagingEventDto;
import com.finconsgroup.itserr.messaging.exception.WP2MessagingException;
import com.finconsgroup.itserr.messaging.producer.MessageProducer;
import com.finconsgroup.itserr.messaging.producer.ProducerRegistry;
import java.util.Map;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.lang.NonNull;
import org.springframework.stereotype.Component;

@Component
@ConditionalOnProperty(name={"messaging.enabled"}, havingValue="true")
public class DefaultEventProducer
implements EventProducer {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DefaultEventProducer.class);
    private final MessageProducer messageProducer;
    private final EventBsConfigurationProperties.Messaging messagingProperties;

    public DefaultEventProducer(EventBsConfigurationProperties bsConfigurationProperties, ProducerRegistry producerRegistry) {
        this.messagingProperties = bsConfigurationProperties.getMessaging();
        this.messageProducer = producerRegistry.getMessageProducer(this.messagingProperties.getEventProducerName());
    }

    public void publishCreateEvent(@NonNull MessagingEventDto<?> eventDto) {
        this.publish(eventDto, this.messagingProperties.getResourceCreatedEventType());
    }

    public void publishUpdateEvent(@NonNull MessagingEventDto<?> eventDto) {
        this.publish(eventDto, this.messagingProperties.getResourceUpdatedEventType());
    }

    public void publishDeleteEvent(@NonNull MessagingEventDto<?> eventDto) {
        this.publish(eventDto, this.messagingProperties.getResourceDeletedEventType());
    }

    public void publishSubscriptionEvent(@NonNull MessagingEventDto<?> eventDto) {
        this.publish(eventDto, this.messagingProperties.getResourceSubscriptionEventType());
    }

    public void publishUnSubscriptionEvent(@NonNull MessagingEventDto<?> eventDto) {
        this.publish(eventDto, this.messagingProperties.getResourceUnSubscriptionEventType());
    }

    private void publish(@NonNull MessagingEventDto<?> eventDto, @NonNull String eventType) {
        try {
            Map<String, MessagingEventDto<?>> messageMap = Map.of(eventDto.getId(), eventDto);
            Map<String, String> filterProperties = Map.of("service", "event");
            log.debug("Sending message, messageMap: {}, eventType: {}, source: {}, filterProperties: {}", new Object[]{messageMap, eventType, this.messagingProperties.getSource(), filterProperties});
            this.messageProducer.publishEvent(messageMap, eventType, this.messagingProperties.getSource(), filterProperties);
            log.info("Successfully published event message for resource with id: {}", (Object)eventDto.getId());
        }
        catch (Exception e) {
            String errorMessage = "Error occurred while sending event message: %s".formatted(e.getMessage());
            throw new WP2MessagingException(errorMessage);
        }
    }
}

