package com.finconsgroup.itserr.marketplace.event.bs.client;

import com.finconsgroup.itserr.marketplace.core.web.dto.OutputPageDto;
import com.finconsgroup.itserr.marketplace.core.web.enums.SortDirection;
import com.finconsgroup.itserr.marketplace.event.bs.client.dto.institutionalpage.InputSearchForMemberInstitutionalPageDto;
import com.finconsgroup.itserr.marketplace.event.bs.client.dto.institutionalpage.InputSearchPublishedInstitutionalPageDto;
import com.finconsgroup.itserr.marketplace.event.bs.client.dto.institutionalpage.InstitutionalPageView;
import com.finconsgroup.itserr.marketplace.event.bs.client.dto.institutionalpage.OutputInstitutionalPageDmDto;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

import java.util.Set;

/**
 * Feign Client interface for Institutional Pages Domain Service
 */
public interface InstitutionalPageDmClient {

    /**
     * Retrieves a paginated list of all InstitutionalPages the user is contributing to, matching the search criteria.
     *
     * @param view                                     the selection strategy to apply (default: {@code LATEST})
     * @param inputSearchForMemberInstitutionalPageDto the dto containing the filters to be applied
     * @param associationsToLoad                       comma separated list of the associations to be returned (default is "all").
     * @param pageNumber                               the page number to retrieve (default is 0)
     * @param pageSize                                 the number of InstitutionalPages per page (default is 10)
     * @param sort                                     the field to sort by (default is "name")
     * @param direction                                the direction of sorting (default is ascending)
     * @return a page of {@link OutputInstitutionalPageDmDto} and HTTP status 200 (OK)
     */
    @PostMapping(value = "/institutional-page/institutional-pages/search",
            consumes = MediaType.APPLICATION_JSON_VALUE,
            produces = MediaType.APPLICATION_JSON_VALUE)
    OutputPageDto<OutputInstitutionalPageDmDto> search(
            @RequestParam(name = "view") InstitutionalPageView view,
            @RequestBody InputSearchForMemberInstitutionalPageDto inputSearchForMemberInstitutionalPageDto,
            @RequestParam(name = "associationsToLoad") Set<String> associationsToLoad,
            @RequestParam(name = "pageNumber") int pageNumber,
            @RequestParam(name = "pageSize") int pageSize,
            @RequestParam(name = "sort") String sort,
            @RequestParam(name = "direction") SortDirection direction
    );

    /**
     * Retrieves a paginated list of all Published InstitutionalPages, matching the search criteria.
     *
     * @param inputSearchPublishedInstitutionalPageDto the dto containing the filters to be applied
     * @param associationsToLoad                       comma separated list of the associations to be returned (default is "all").
     * @param pageNumber                               the page number to retrieve (default is 0)
     * @param pageSize                                 the number of InstitutionalPages per page (default is 10)
     * @param sort                                     the field to sort by (default is "name")
     * @param direction                                the direction of sorting (default is ascending)
     * @return a page of {@link OutputInstitutionalPageDmDto} and HTTP status 200 (OK)
     */
    @PostMapping(
            value = "/institutional-page/institutional-pages/published/search",
            consumes = MediaType.APPLICATION_JSON_VALUE,
            produces = MediaType.APPLICATION_JSON_VALUE
    )
    OutputPageDto<OutputInstitutionalPageDmDto> searchPublishedInstitutionalPages(
            @RequestBody InputSearchPublishedInstitutionalPageDto inputSearchPublishedInstitutionalPageDto,
            @RequestParam(name = "associationsToLoad") Set<String> associationsToLoad,
            @RequestParam(name = "pageNumber") int pageNumber,
            @RequestParam(name = "pageSize") int pageSize,
            @RequestParam(name = "sort") String sort,
            @RequestParam(name = "direction") SortDirection direction
    );
}
