/*
 * Decompiled with CFR 0.152.
 */
package com.finconsgroup.itserr.marketplace.event.bs.client;

import com.finconsgroup.itserr.marketplace.core.web.dto.OutputPageDto;
import com.finconsgroup.itserr.marketplace.core.web.enums.SortDirection;
import com.finconsgroup.itserr.marketplace.event.bs.dto.InputCreateEventDto;
import com.finconsgroup.itserr.marketplace.event.bs.dto.InputProgramSubscribedParticipantDto;
import com.finconsgroup.itserr.marketplace.event.bs.dto.InputUpdateEventDto;
import com.finconsgroup.itserr.marketplace.event.bs.dto.OutputEventDto;
import com.finconsgroup.itserr.marketplace.event.bs.dto.OutputPublicImageDto;
import java.util.Set;
import java.util.UUID;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RequestPart;
import org.springframework.web.multipart.MultipartFile;

public interface EventBsClient {
    @GetMapping(value={"/event/events"}, produces={"application/json"})
    public OutputPageDto<OutputEventDto> findAll(@RequestParam(name="associationsToLoad") Set<String> var1, @RequestParam(name="pageNumber") int var2, @RequestParam(name="pageSize") int var3, @RequestParam(name="sort") String var4, @RequestParam(name="direction") SortDirection var5);

    @GetMapping(value={"/event/events/{id}"}, produces={"application/json"})
    public OutputEventDto findById(@PathVariable(value="id") UUID var1);

    @PostMapping(value={"/event/events"}, consumes={"application/json"}, produces={"application/json"})
    public OutputEventDto createEvent(@RequestBody InputCreateEventDto var1);

    @PutMapping(value={"/event/events/{id}"}, consumes={"application/json"}, produces={"application/json"})
    public OutputEventDto updateEventById(@PathVariable(value="id") UUID var1, @RequestBody InputUpdateEventDto var2);

    @DeleteMapping(value={"/event/events/{id}"})
    public void deleteEventById(@PathVariable(value="id") UUID var1);

    @PostMapping(path={"/event/images"}, consumes={"multipart/form-data"}, produces={"application/json"})
    public OutputPublicImageDto createPublicImage(@RequestPart MultipartFile var1);

    @PutMapping(path={"/event/images/{id}"}, consumes={"multipart/form-data"}, produces={"application/json"})
    public OutputPublicImageDto updatePublicImage(@PathVariable String var1, @RequestPart MultipartFile var2);

    @PostMapping(value={"/event/events/{id}/register"}, produces={"application/json"})
    public OutputEventDto register(@PathVariable(value="id") UUID var1);

    @DeleteMapping(value={"/event/events/{id}/register"}, produces={"application/json"})
    public OutputEventDto unregister(@PathVariable(value="id") UUID var1);

    @PostMapping(value={"/event/events/{eventId}/programs/{programId}/register"}, produces={"application/json"})
    public OutputEventDto registerProgram(@PathVariable(value="eventId") UUID var1, @PathVariable(value="programId") UUID var2, @RequestBody InputProgramSubscribedParticipantDto var3);

    @DeleteMapping(value={"/event/events/{eventId}/programs/{programId}/register"}, produces={"application/json"})
    public OutputEventDto unregisterProgram(@PathVariable(value="eventId") UUID var1, @PathVariable(value="programId") UUID var2);
}

