package com.finconsgroup.itserr.marketplace.echo.dm.configuration;

import com.finconsgroup.itserr.marketplace.echo.dm.websocket.NotificationsWebSocketHandler;
import com.finconsgroup.itserr.marketplace.echo.dm.websocket.WsHandshakeInterceptor;
import lombok.RequiredArgsConstructor;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.socket.config.annotation.EnableWebSocket;
import org.springframework.web.socket.config.annotation.WebSocketConfigurer;
import org.springframework.web.socket.config.annotation.WebSocketHandlerRegistry;

@Configuration
@EnableWebSocket
@RequiredArgsConstructor
public class WebSocketConfig implements WebSocketConfigurer {

    private final NotificationsWebSocketHandler handler;
    private final WsHandshakeInterceptor handshakeInterceptor;

    @Override
    public void registerWebSocketHandlers(
            final WebSocketHandlerRegistry registry) {
        registry
                .addHandler(handler, "/notifications/ws")
                .addInterceptors(handshakeInterceptor)
                .setAllowedOrigins("*");
    }

}
