package com.finconsgroup.itserr.marketplace.echo.dm.websocket;

import org.springframework.lang.NonNull;
import org.springframework.stereotype.Component;
import org.springframework.web.socket.CloseStatus;
import org.springframework.web.socket.TextMessage;
import org.springframework.web.socket.WebSocketSession;
import org.springframework.web.socket.handler.TextWebSocketHandler;

import java.io.IOException;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

@Component
public class NotificationsWebSocketHandler extends TextWebSocketHandler {

    private final Set<WebSocketSession> sessions = new HashSet<>();

    @Override
    public void afterConnectionEstablished(@NonNull final WebSocketSession session) {
        synchronized (sessions) {
            sessions.add(session);
        }
        try {
            send(
                    session,
                    "Connected as user: " + session.getAttributes().get(WsHandshakeInterceptor.USERNAME_ATTR));
        } catch (Exception e) {
            // FIXME: handle
        }
    }

    @Override
    protected void handleTextMessage(
            @NonNull final WebSocketSession session,
            @NonNull final TextMessage message) {
    }

    @Override
    public void afterConnectionClosed(
            @NonNull final WebSocketSession session,
            @NonNull final CloseStatus status) {
        synchronized (sessions) {
            sessions.remove(session);
        }
    }

    public void send(final String message) {
        send((String) null, message);
    }

    public void send(
            final String username,
            final String message) {

        // Find message target sessions
        List<WebSocketSession> targetSessions;
        synchronized (sessions) {
            targetSessions = sessions.stream()
                    .filter(s -> username == null || username.equals(s.getAttributes().get(WsHandshakeInterceptor.USERNAME_ATTR)))
                    .toList();
        }

        // Send message
        for (final WebSocketSession session : targetSessions) {
            try {
                send(session, message);
            } catch (Exception e) {
                // FIXME: handle
            }
        }

    }

    private void send(
            final WebSocketSession session,
            final String message) throws IOException {

        session.sendMessage(new TextMessage(message));

    }

}
