/*
 * Decompiled with CFR 0.152.
 */
package com.finconsgroup.itserr.marketplace.echo.dm.api;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.security.SecurityRequirement;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.util.Map;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.ResponseStatus;

@Tag(name="Orders", description="The Orders API: it provides endpoints for retrieving Orders.")
@SecurityRequirement(name="BearerAuth")
public interface OrderApi {
    @Operation(summary="Find all users", responses={@ApiResponse(responseCode="200", description="OK")})
    @GetMapping(value={"/users"}, produces={"application/json"})
    @ResponseStatus(value=HttpStatus.OK)
    public String findAllUsers(@RequestHeader Map<String, String> var1);

    @Operation(summary="delete all users", responses={@ApiResponse(responseCode="200", description="OK")})
    @DeleteMapping(value={"/users"}, produces={"application/json"})
    @ResponseStatus(value=HttpStatus.OK)
    public String deleteAllUsers(@RequestHeader Map<String, String> var1);

    @Operation(summary="Find user by user id", responses={@ApiResponse(responseCode="200", description="OK")})
    @GetMapping(value={"/users/{userId}"}, produces={"application/json"})
    @ResponseStatus(value=HttpStatus.OK)
    public String findUserByUserId(@PathVariable String var1, @RequestHeader Map<String, String> var2);

    @Operation(summary="Delete user by user id", responses={@ApiResponse(responseCode="200", description="OK")})
    @DeleteMapping(value={"/users/{userId}"}, produces={"application/json"})
    @ResponseStatus(value=HttpStatus.OK)
    public String deleteUserByUserId(@PathVariable String var1, @RequestHeader Map<String, String> var2);

    @Operation(summary="Find all orders by user id", responses={@ApiResponse(responseCode="200", description="OK")})
    @GetMapping(value={"/users/{userId}/orders"}, produces={"application/json"})
    @ResponseStatus(value=HttpStatus.OK)
    public String findAllOrdersByUserId(@PathVariable String var1, @RequestHeader Map<String, String> var2);

    @Operation(summary="Delete all orders by user id", responses={@ApiResponse(responseCode="200", description="OK")})
    @DeleteMapping(value={"/users/{userId}/orders"}, produces={"application/json"})
    @ResponseStatus(value=HttpStatus.OK)
    public String deleteAllOrdersByUserId(@PathVariable String var1, @RequestHeader Map<String, String> var2);

    @Operation(summary="Find order by user id and order id", responses={@ApiResponse(responseCode="200", description="OK")})
    @GetMapping(value={"/users/{userId}/orders/{orderId}"}, produces={"application/json"})
    @ResponseStatus(value=HttpStatus.OK)
    public String findOrderByUserIdAndOrderId(@PathVariable String var1, @PathVariable String var2, @RequestHeader Map<String, String> var3);

    @Operation(summary="Delete order by user id and order id", responses={@ApiResponse(responseCode="200", description="OK")})
    @DeleteMapping(value={"/users/{userId}/orders/{orderId}"}, produces={"application/json"})
    @ResponseStatus(value=HttpStatus.OK)
    public String deleteOrderByUserIdAndOrderId(@PathVariable String var1, @PathVariable String var2, @RequestHeader Map<String, String> var3);
}

