package com.finconsgroup.itserr.marketplace.echo.dm.websocket;

import com.finconsgroup.itserr.marketplace.core.web.security.jwt.JwtTokenHolder;
import io.micrometer.common.util.StringUtils;
import org.springframework.http.server.ServerHttpRequest;
import org.springframework.http.server.ServerHttpResponse;
import org.springframework.lang.NonNull;
import org.springframework.stereotype.Component;
import org.springframework.web.socket.WebSocketHandler;
import org.springframework.web.socket.server.HandshakeInterceptor;

import java.util.Map;
import java.util.UUID;

@Component
public class WsHandshakeInterceptor implements HandshakeInterceptor {

    // TODO: should be moved in a common place
    public static final String USER_ID_ATTR = "userId";
    // TODO: should be moved in a common place
    public static final String USERNAME_ATTR = "username";

    @Override
    public boolean beforeHandshake(
            @NonNull final ServerHttpRequest request,
            @NonNull final ServerHttpResponse response,
            @NonNull final WebSocketHandler wsHandler,
            @NonNull final Map<String, Object> attributes) throws Exception {

        // FIXME: should we check that the token is valid? we usally trust it

        final UUID userId = JwtTokenHolder.getUserId().orElse(null);
        final String username = JwtTokenHolder.getPreferredUsername().orElse(null);
        if (userId == null || StringUtils.isBlank(username)) {
            return false;
        }

        attributes.put(USER_ID_ATTR, userId);
        attributes.put(USERNAME_ATTR, username);
        return true;
    }

    @Override
    public void afterHandshake(
            @NonNull final ServerHttpRequest request,
            @NonNull final ServerHttpResponse response,
            @NonNull final WebSocketHandler wsHandler,
            final Exception exception) {
        // Do nothing
    }
}
