package com.finconsgroup.itserr.marketplace.echo.dm.controller;

import com.finconsgroup.itserr.marketplace.echo.dm.websocket.NotificationsWebSocketHandler;
import lombok.RequiredArgsConstructor;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequiredArgsConstructor
public class NotificationController {

    private final NotificationsWebSocketHandler wsHandler;

    @PostMapping(path = "/notifications", consumes = "text/plain")
    public void sendNotification(
            @RequestParam(name = "username", required = false) final String username,
            @RequestBody final String message) {
        wsHandler.send(username, message);
    }

}
