/*
 * Decompiled with CFR 0.152.
 */
package com.finconsgroup.itserr.marketplace.discussion.dm.service.impl;

import com.finconsgroup.itserr.marketplace.core.web.exception.WP2AuthorizationException;
import com.finconsgroup.itserr.marketplace.core.web.exception.WP2DuplicateResourceException;
import com.finconsgroup.itserr.marketplace.core.web.exception.WP2ResourceNotFoundException;
import com.finconsgroup.itserr.marketplace.discussion.dm.bean.DiscussionFilterRequest;
import com.finconsgroup.itserr.marketplace.discussion.dm.dto.DiscussionDTO;
import com.finconsgroup.itserr.marketplace.discussion.dm.dto.InputUpdateDiscussionDto;
import com.finconsgroup.itserr.marketplace.discussion.dm.dto.ThreadDTO;
import com.finconsgroup.itserr.marketplace.discussion.dm.entity.Discussion;
import com.finconsgroup.itserr.marketplace.discussion.dm.entity.DiscussionReaction;
import com.finconsgroup.itserr.marketplace.discussion.dm.entity.Thread;
import com.finconsgroup.itserr.marketplace.discussion.dm.entity.ThreadReaction;
import com.finconsgroup.itserr.marketplace.discussion.dm.enums.ReactionType;
import com.finconsgroup.itserr.marketplace.discussion.dm.mapper.DiscussionMapper;
import com.finconsgroup.itserr.marketplace.discussion.dm.mapper.ThreadMapper;
import com.finconsgroup.itserr.marketplace.discussion.dm.repository.DiscussionReactionRepository;
import com.finconsgroup.itserr.marketplace.discussion.dm.repository.DiscussionRepository;
import com.finconsgroup.itserr.marketplace.discussion.dm.repository.ThreadReactionRepository;
import com.finconsgroup.itserr.marketplace.discussion.dm.repository.ThreadRepository;
import com.finconsgroup.itserr.marketplace.discussion.dm.repository.specification.DiscussionSpecifications;
import com.finconsgroup.itserr.marketplace.discussion.dm.service.DiscussionService;
import java.time.Instant;
import java.util.Optional;
import java.util.UUID;
import lombok.Generated;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class DiscussionServiceImpl
implements DiscussionService {
    private static final String RESOURCE_ID_TYPE_BUSINESS_KEY = "{resourceId: %s, resourceType: %s}";
    private final DiscussionRepository discussionRepository;
    private final ThreadRepository threadRepository;
    private final DiscussionReactionRepository discussionReactionRepository;
    private final ThreadReactionRepository threadReactionRepository;
    private final DiscussionMapper discussionMapper;
    private final ThreadMapper threadMapper;

    @Transactional(readOnly=true)
    public DiscussionDTO getDiscussionForResource(String resourceId, String resourceType) {
        UUID resourceIdUuid = UUID.fromString(resourceId);
        Discussion discussion = (Discussion)this.discussionRepository.findByResourceIdAndResourceType(resourceIdUuid, resourceType).orElseThrow(() -> new WP2ResourceNotFoundException(String.format("Discussion not found for resource: %s, %s", resourceId, resourceType)));
        return this.discussionMapper.toDTO(discussion);
    }

    @Transactional(readOnly=true)
    public DiscussionDTO getDiscussionById(String id, boolean includeThreads) {
        UUID uuid = UUID.fromString(id);
        Discussion discussion = (Discussion)this.discussionRepository.findById((Object)uuid).orElseThrow(() -> new WP2ResourceNotFoundException(String.format("Discussion not found with id: %s", id)));
        return includeThreads ? this.discussionMapper.toDTO(discussion) : this.discussionMapper.toDTOWithoutThreads(discussion);
    }

    @Transactional(readOnly=true)
    public Page<DiscussionDTO> getDiscussions(Pageable pageable, DiscussionFilterRequest filterRequest, boolean includeThreads) {
        Page discussions;
        if (filterRequest != null && filterRequest.hasAnyFilter()) {
            Specification filterSpec = DiscussionSpecifications.hasVisibility((String)filterRequest.visibility()).and(DiscussionSpecifications.hasResourceType((String)filterRequest.resourceType())).and(DiscussionSpecifications.isCreatedAfter((Instant)filterRequest.createdAfter()));
            discussions = this.discussionRepository.findAll(filterSpec, pageable);
        } else {
            discussions = this.discussionRepository.findAll(pageable);
        }
        if (includeThreads) {
            return discussions.map(arg_0 -> ((DiscussionMapper)this.discussionMapper).toDTO(arg_0));
        }
        return discussions.map(arg_0 -> ((DiscussionMapper)this.discussionMapper).toDTOWithoutThreads(arg_0));
    }

    public DiscussionDTO createDiscussion(DiscussionDTO discussionDTO) {
        if (discussionDTO.getResourceId() != null && this.discussionRepository.existsByResourceIdAndResourceType(discussionDTO.getResourceId(), discussionDTO.getResourceType())) {
            throw new WP2DuplicateResourceException(RESOURCE_ID_TYPE_BUSINESS_KEY.formatted(discussionDTO.getResourceId(), discussionDTO.getResourceType()));
        }
        Discussion discussion = this.discussionMapper.toEntity(discussionDTO);
        Discussion savedDiscussion = (Discussion)this.discussionRepository.saveAndFlush((Object)discussion);
        return this.discussionMapper.toDTOWithoutThreads(savedDiscussion);
    }

    public ResponseEntity<Void> deleteDiscussion(String id) {
        UUID uuid = UUID.fromString(id);
        if (!this.discussionRepository.existsById((Object)uuid)) {
            throw new WP2ResourceNotFoundException(String.format("Discussion not found with id: %s", id));
        }
        this.discussionRepository.deleteById((Object)uuid);
        return ResponseEntity.noContent().build();
    }

    @Transactional(readOnly=true)
    public Page<ThreadDTO> getThreadsByDiscussionId(String discussionId, Pageable pageable) {
        UUID uuid = UUID.fromString(discussionId);
        Discussion discussion = (Discussion)this.discussionRepository.findById((Object)uuid).orElseThrow(() -> new WP2ResourceNotFoundException(String.format("Discussion not found with id: %s", discussionId)));
        Page threads = this.threadRepository.findByDiscussionAndParentIsNull(discussion, pageable);
        return threads.map(arg_0 -> ((ThreadMapper)this.threadMapper).toDTO(arg_0));
    }

    public ResponseEntity<ThreadDTO> addThread(String discussionId, ThreadDTO threadDTO) {
        UUID discussionUuid = UUID.fromString(discussionId);
        Discussion discussion = (Discussion)this.discussionRepository.findById((Object)discussionUuid).orElseThrow(() -> new WP2ResourceNotFoundException(String.format("Discussion not found with id: %s", discussionId)));
        Thread thread = Thread.builder().discussion(discussion).createdBy(threadDTO.getCreatedBy()).content(threadDTO.getContent()).createdAt(Instant.now()).build();
        if (threadDTO.getParentId() != null) {
            this.threadRepository.findById((Object)threadDTO.getParentId()).ifPresent(arg_0 -> ((Thread)thread).setParent(arg_0));
        }
        Thread threadEntity = (Thread)this.threadRepository.saveAndFlush((Object)thread);
        return ResponseEntity.status((HttpStatusCode)HttpStatus.CREATED).body((Object)this.threadMapper.toDTO(threadEntity));
    }

    public ResponseEntity<Void> deleteThread(String discussionId, String threadId) {
        UUID discussionUuid = UUID.fromString(discussionId);
        UUID threadUuid = UUID.fromString(threadId);
        Discussion discussion = (Discussion)this.discussionRepository.findById((Object)discussionUuid).orElseThrow(() -> new WP2ResourceNotFoundException(String.format("Discussion not found with id: %s", discussionId)));
        Thread thread = (Thread)this.threadRepository.findById((Object)threadUuid).orElseThrow(() -> new WP2ResourceNotFoundException(String.format("Thread not found with id: %s", threadId)));
        if (!thread.getDiscussion().getId().equals(discussion.getId())) {
            return ResponseEntity.badRequest().build();
        }
        this.threadRepository.deleteById((Object)threadUuid);
        return ResponseEntity.noContent().build();
    }

    public ResponseEntity<ThreadDTO> updateThread(String discussionId, String threadId, ThreadDTO threadDTO) {
        UUID discussionUuid = UUID.fromString(discussionId);
        UUID threadUuid = UUID.fromString(threadId);
        Discussion discussion = (Discussion)this.discussionRepository.findById((Object)discussionUuid).orElseThrow(() -> new WP2ResourceNotFoundException(String.format("Discussion not found with id: %s", discussionId)));
        Thread thread = (Thread)this.threadRepository.findById((Object)threadUuid).orElseThrow(() -> new WP2ResourceNotFoundException(String.format("Thread not found with id: %s", threadId)));
        if (!thread.getDiscussion().getId().equals(discussionUuid)) {
            return ResponseEntity.badRequest().build();
        }
        if (threadDTO.getContent() != null) {
            thread.setContent(threadDTO.getContent());
            thread.setModifiedAt(Instant.now());
        }
        Thread threadEntity = (Thread)this.threadRepository.saveAndFlush((Object)thread);
        return ResponseEntity.ok((Object)this.threadMapper.toDTO(threadEntity));
    }

    public ResponseEntity<Void> addReactionToDiscussion(String discussionId, String userId, ReactionType reactionType) {
        UUID discussionUuid = UUID.fromString(discussionId);
        Discussion discussion = (Discussion)this.discussionRepository.findById((Object)discussionUuid).orElseThrow(() -> new WP2ResourceNotFoundException(String.format("Discussion not found with id: %s", discussionId)));
        Optional existingReaction = this.discussionReactionRepository.findByDiscussionAndUserId(discussion, userId);
        if (existingReaction.isEmpty()) {
            DiscussionReaction reaction = DiscussionReaction.builder().discussion(discussion).userId(userId).reaction(reactionType).createdAt(Instant.now()).build();
            this.discussionReactionRepository.saveAndFlush((Object)reaction);
            return ResponseEntity.status((HttpStatusCode)HttpStatus.CREATED).build();
        }
        if (!((DiscussionReaction)existingReaction.get()).getReaction().equals((Object)reactionType)) {
            ((DiscussionReaction)existingReaction.get()).setReaction(reactionType);
            this.discussionReactionRepository.saveAndFlush((Object)((DiscussionReaction)existingReaction.get()));
            return ResponseEntity.status((HttpStatusCode)HttpStatus.CREATED).build();
        }
        this.discussionReactionRepository.delete((Object)((DiscussionReaction)existingReaction.get()));
        return ResponseEntity.status((HttpStatusCode)HttpStatus.CREATED).build();
    }

    public ResponseEntity<Void> removeReactionFromDiscussion(String discussionId, String userId) {
        UUID discussionUuid = UUID.fromString(discussionId);
        Discussion discussion = (Discussion)this.discussionRepository.findById((Object)discussionUuid).orElseThrow(() -> new WP2ResourceNotFoundException(String.format("Discussion not found with id: %s", discussionId)));
        this.discussionReactionRepository.deleteByDiscussionAndUserId(discussion, userId);
        return ResponseEntity.noContent().build();
    }

    public ResponseEntity<Void> addReactionToThread(String discussionId, String threadId, String userId, ReactionType reactionType) {
        UUID discussionUuid = UUID.fromString(discussionId);
        UUID threadUuid = UUID.fromString(threadId);
        Discussion discussion = (Discussion)this.discussionRepository.findById((Object)discussionUuid).orElseThrow(() -> new WP2ResourceNotFoundException(String.format("Discussion not found with id: %s", discussionId)));
        Thread thread = (Thread)this.threadRepository.findById((Object)threadUuid).orElseThrow(() -> new WP2ResourceNotFoundException(String.format("Thread not found with id: %s", threadId)));
        if (!thread.getDiscussion().getId().equals(discussion.getId())) {
            return ResponseEntity.badRequest().build();
        }
        Optional existingReaction = this.threadReactionRepository.findByThreadAndUserId(thread, userId);
        if (existingReaction.isEmpty()) {
            ThreadReaction reaction = ThreadReaction.builder().thread(thread).userId(userId).reaction(reactionType).createdAt(Instant.now()).build();
            this.threadReactionRepository.saveAndFlush((Object)reaction);
            return ResponseEntity.status((HttpStatusCode)HttpStatus.CREATED).build();
        }
        if (!((ThreadReaction)existingReaction.get()).getReaction().equals((Object)reactionType)) {
            ((ThreadReaction)existingReaction.get()).setReaction(reactionType);
            this.threadReactionRepository.saveAndFlush((Object)((ThreadReaction)existingReaction.get()));
            return ResponseEntity.status((HttpStatusCode)HttpStatus.CREATED).build();
        }
        this.threadReactionRepository.delete((Object)((ThreadReaction)existingReaction.get()));
        return ResponseEntity.status((HttpStatusCode)HttpStatus.CREATED).build();
    }

    public ResponseEntity<Void> removeReactionFromThread(String discussionId, String threadId, String userId) {
        UUID discussionUuid = UUID.fromString(discussionId);
        UUID threadUuid = UUID.fromString(threadId);
        Discussion discussion = (Discussion)this.discussionRepository.findById((Object)discussionUuid).orElseThrow(() -> new WP2ResourceNotFoundException(String.format("Discussion not found with id: %s", discussionId)));
        Thread thread = (Thread)this.threadRepository.findById((Object)threadUuid).orElseThrow(() -> new WP2ResourceNotFoundException(String.format("Thread not found with id: %s", threadId)));
        if (!thread.getDiscussion().getId().equals(discussionUuid)) {
            return ResponseEntity.badRequest().build();
        }
        this.threadReactionRepository.deleteByThreadAndUserId(thread, userId);
        return ResponseEntity.noContent().build();
    }

    public DiscussionDTO updateDiscussion(UUID discussionId, InputUpdateDiscussionDto inputUpdateDiscussionDto, boolean includeThreads, String currentUser) {
        Discussion discussion = (Discussion)this.discussionRepository.findById((Object)discussionId).orElseThrow(() -> new WP2ResourceNotFoundException(discussionId));
        if (!"social".equalsIgnoreCase(discussion.getResourceType())) {
            throw new WP2AuthorizationException("Only social discussions can be updated.");
        }
        if (!discussion.getCreatedBy().equals(currentUser)) {
            throw new WP2AuthorizationException("You are not authorized to update this discussion");
        }
        if (inputUpdateDiscussionDto.getTitle() != null && !inputUpdateDiscussionDto.getTitle().isBlank()) {
            discussion.setTitle(inputUpdateDiscussionDto.getTitle());
        }
        if (inputUpdateDiscussionDto.getContent() != null && !inputUpdateDiscussionDto.getContent().isBlank()) {
            discussion.setContent(inputUpdateDiscussionDto.getContent());
        }
        if (inputUpdateDiscussionDto.getUrl() != null) {
            discussion.setUrl(inputUpdateDiscussionDto.getUrl());
        }
        discussion.setUpdatedBy(currentUser);
        Discussion updatedDiscussion = (Discussion)this.discussionRepository.saveAndFlush((Object)discussion);
        return includeThreads ? this.discussionMapper.toDTO(updatedDiscussion) : this.discussionMapper.toDTOWithoutThreads(updatedDiscussion);
    }

    @Generated
    public DiscussionServiceImpl(DiscussionRepository discussionRepository, ThreadRepository threadRepository, DiscussionReactionRepository discussionReactionRepository, ThreadReactionRepository threadReactionRepository, DiscussionMapper discussionMapper, ThreadMapper threadMapper) {
        this.discussionRepository = discussionRepository;
        this.threadRepository = threadRepository;
        this.discussionReactionRepository = discussionReactionRepository;
        this.threadReactionRepository = threadReactionRepository;
        this.discussionMapper = discussionMapper;
        this.threadMapper = threadMapper;
    }
}

