package com.finconsgroup.itserr.marketplace.discussion.dm.mapper;

import com.finconsgroup.itserr.marketplace.discussion.dm.dto.ThreadDTO;
import com.finconsgroup.itserr.marketplace.discussion.dm.dto.ThreadReactionDTO;
import com.finconsgroup.itserr.marketplace.discussion.dm.entity.Thread;
import com.finconsgroup.itserr.marketplace.discussion.dm.entity.ThreadReaction;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import javax.annotation.processing.Generated;
import org.springframework.stereotype.Component;

@Generated(
    value = "org.mapstruct.ap.MappingProcessor",
    date = "2026-02-12T10:20:34+0000",
    comments = "version: 1.6.3, compiler: javac, environment: Java 21.0.9 (Eclipse Adoptium)"
)
@Component
public class ThreadMapperImpl extends ThreadMapper {

    @Override
    public ThreadDTO toDTO(Thread thread) {
        if ( thread == null ) {
            return null;
        }

        ThreadDTO.ThreadDTOBuilder threadDTO = ThreadDTO.builder();

        threadDTO.parentId( threadParentId( thread ) );
        threadDTO.id( thread.getId() );
        threadDTO.createdBy( thread.getCreatedBy() );
        threadDTO.createdAt( thread.getCreatedAt() );
        threadDTO.modifiedAt( thread.getModifiedAt() );
        threadDTO.content( thread.getContent() );
        threadDTO.replies( mapThreadRepliesToDTO( thread.getReplies() ) );
        threadDTO.reactions( threadReactionListToThreadReactionDTOList( thread.getReactions() ) );

        ThreadDTO threadDTOResult = threadDTO.build();

        afterToDTO( thread, threadDTOResult );

        return threadDTOResult;
    }

    @Override
    public Thread toEntity(ThreadDTO dto) {
        if ( dto == null ) {
            return null;
        }

        Thread.ThreadBuilder thread = Thread.builder();

        thread.id( dto.getId() );
        thread.createdBy( dto.getCreatedBy() );
        thread.createdAt( dto.getCreatedAt() );
        thread.modifiedAt( dto.getModifiedAt() );
        thread.content( dto.getContent() );

        return thread.build();
    }

    private UUID threadParentId(Thread thread) {
        Thread parent = thread.getParent();
        if ( parent == null ) {
            return null;
        }
        return parent.getId();
    }

    protected ThreadReactionDTO threadReactionToThreadReactionDTO(ThreadReaction threadReaction) {
        if ( threadReaction == null ) {
            return null;
        }

        ThreadReactionDTO.ThreadReactionDTOBuilder threadReactionDTO = ThreadReactionDTO.builder();

        threadReactionDTO.id( threadReaction.getId() );
        threadReactionDTO.userId( threadReaction.getUserId() );
        threadReactionDTO.reaction( threadReaction.getReaction() );
        threadReactionDTO.createdAt( threadReaction.getCreatedAt() );

        return threadReactionDTO.build();
    }

    protected List<ThreadReactionDTO> threadReactionListToThreadReactionDTOList(List<ThreadReaction> list) {
        if ( list == null ) {
            return null;
        }

        List<ThreadReactionDTO> list1 = new ArrayList<ThreadReactionDTO>( list.size() );
        for ( ThreadReaction threadReaction : list ) {
            list1.add( threadReactionToThreadReactionDTO( threadReaction ) );
        }

        return list1;
    }
}
