/*
 * Decompiled with CFR 0.152.
 */
package com.finconsgroup.itserr.marketplace.discussion.dm.controller;

import com.finconsgroup.itserr.marketplace.core.web.security.jwt.JwtTokenHolder;
import com.finconsgroup.itserr.marketplace.discussion.dm.api.DiscussionApi;
import com.finconsgroup.itserr.marketplace.discussion.dm.bean.DiscussionFilterRequest;
import com.finconsgroup.itserr.marketplace.discussion.dm.dto.DiscussionDTO;
import com.finconsgroup.itserr.marketplace.discussion.dm.dto.InputUpdateDiscussionDto;
import com.finconsgroup.itserr.marketplace.discussion.dm.dto.ThreadDTO;
import com.finconsgroup.itserr.marketplace.discussion.dm.enums.ReactionType;
import com.finconsgroup.itserr.marketplace.discussion.dm.service.DiscussionService;
import java.time.Instant;
import java.util.UUID;
import lombok.Generated;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class DiscussionController
implements DiscussionApi {
    private final DiscussionService discussionService;

    public DiscussionDTO getDiscussionById(String id, boolean includeThreads) {
        return this.discussionService.getDiscussionById(id, includeThreads);
    }

    public DiscussionDTO getDiscussionForResource(String resourceId, String resourceType) {
        return this.discussionService.getDiscussionForResource(resourceId, resourceType);
    }

    public Page<DiscussionDTO> getDiscussions(int page, int size, String sortBy, Sort.Direction direction, String visibility, boolean includeThreads, String resourceType, Instant createdAfter) {
        PageRequest pageable = PageRequest.of((int)page, (int)size, (Sort.Direction)direction, (String[])new String[]{sortBy});
        DiscussionFilterRequest filterRequest = DiscussionFilterRequest.builder().visibility(visibility).resourceType(resourceType).createdAfter(createdAfter).build();
        return this.discussionService.getDiscussions((Pageable)pageable, filterRequest, includeThreads);
    }

    public DiscussionDTO createDiscussion(DiscussionDTO discussionDTO) {
        return this.discussionService.createDiscussion(discussionDTO);
    }

    public ResponseEntity<Void> deleteDiscussion(String id) {
        return this.discussionService.deleteDiscussion(id);
    }

    public DiscussionDTO updateDiscussion(UUID discussionId, InputUpdateDiscussionDto inputUpdateDiscussionDto, boolean includeThreads) {
        String currentUser = JwtTokenHolder.getPreferredUsernameOrThrow();
        return this.discussionService.updateDiscussion(discussionId, inputUpdateDiscussionDto, includeThreads, currentUser);
    }

    public Page<ThreadDTO> getThreadsByDiscussionId(String discussionId, int page, int size, String sortBy, Sort.Direction direction) {
        PageRequest pageable = PageRequest.of((int)page, (int)size, (Sort.Direction)direction, (String[])new String[]{sortBy});
        return this.discussionService.getThreadsByDiscussionId(discussionId, (Pageable)pageable);
    }

    public ResponseEntity<ThreadDTO> addThread(String discussionId, ThreadDTO threadDTO) {
        return this.discussionService.addThread(discussionId, threadDTO);
    }

    public ResponseEntity<Void> deleteThread(String discussionId, String threadId) {
        return this.discussionService.deleteThread(discussionId, threadId);
    }

    public ResponseEntity<ThreadDTO> updateThread(String discussionId, String threadId, ThreadDTO threadDTO) {
        return this.discussionService.updateThread(discussionId, threadId, threadDTO);
    }

    public ResponseEntity<Void> addReactionToDiscussion(String discussionId, String userId, ReactionType reactionType) {
        return this.discussionService.addReactionToDiscussion(discussionId, userId, reactionType);
    }

    public ResponseEntity<Void> removeReactionFromDiscussion(String discussionId, String userId) {
        return this.discussionService.removeReactionFromDiscussion(discussionId, userId);
    }

    public ResponseEntity<Void> addReactionToThread(String discussionId, String threadId, String userId, ReactionType reactionType) {
        return this.discussionService.addReactionToThread(discussionId, threadId, userId, reactionType);
    }

    public ResponseEntity<Void> removeReactionFromThread(String discussionId, String threadId, String userId) {
        return this.discussionService.removeReactionFromThread(discussionId, threadId, userId);
    }

    @Generated
    public DiscussionController(DiscussionService discussionService) {
        this.discussionService = discussionService;
    }
}

