package com.finconsgroup.itserr.marketplace.discussion.dm.bean;

import lombok.Builder;
import org.apache.commons.lang3.StringUtils;

import java.time.Instant;

/**
 * Bean to represent the filters to be applied to fetch discussions.
 *
 * @param visibility filter by visibility
 * @param resourceType filter by the type of the resource
 * @param createdAfter filter for created after
 */
@Builder
public record DiscussionFilterRequest(
        String visibility,
        String resourceType,
        Instant createdAfter
) {

    /**
     * Indicates if there is at least one filter criteria provided
     *
     * @return {@code true} if filters provided, {@code false} otherwise
     */
    public boolean hasAnyFilter() {
        return StringUtils.isNotBlank(visibility) || StringUtils.isNotBlank(resourceType)
                || createdAfter != null;
    }
}
