/*
 * Decompiled with CFR 0.152.
 */
package com.finconsgroup.itserr.marketplace.discussion.dm.repository.specification;

import com.finconsgroup.itserr.marketplace.discussion.dm.entity.Discussion;
import jakarta.persistence.criteria.Expression;
import java.io.Serializable;
import java.time.Instant;
import org.apache.commons.lang3.StringUtils;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.lang.NonNull;

public final class DiscussionSpecifications {
    private static final String VISIBILITY = "visibility";
    private static final String RESOURCE_TYPE = "resourceType";
    private static final String CREATED_AT = "createdAt";

    private DiscussionSpecifications() {
        throw new UnsupportedOperationException("Cannot be instantiated");
    }

    @NonNull
    public static Specification<Discussion> hasVisibility(String visibility) {
        return (Specification & Serializable)(root, query, cb) -> StringUtils.isBlank((CharSequence)visibility) ? cb.conjunction() : cb.equal((Expression)root.get(VISIBILITY), (Object)visibility);
    }

    @NonNull
    public static Specification<Discussion> hasResourceType(String resourceType) {
        return (Specification & Serializable)(root, query, cb) -> StringUtils.isBlank((CharSequence)resourceType) ? cb.conjunction() : cb.equal((Expression)root.get(RESOURCE_TYPE), (Object)resourceType);
    }

    @NonNull
    public static Specification<Discussion> isCreatedAfter(Instant createdAfter) {
        return (Specification & Serializable)(root, query, cb) -> createdAfter == null ? cb.conjunction() : cb.greaterThanOrEqualTo((Expression)root.get(CREATED_AT), (Comparable)createdAfter);
    }
}

