package com.finconsgroup.itserr.marketplace.discussion.dm.repository;

import com.finconsgroup.itserr.marketplace.discussion.dm.entity.Discussion;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.JpaSpecificationExecutor;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;
import org.springframework.stereotype.Repository;

import java.util.Optional;
import java.util.UUID;

/**
 * DiscussionRepository is a Spring Data JPA repository interface for performing CRUD operations
 * and interacting with the {@code Discussion} entity in the database. It provides methods
 * for basic data access, query execution, and entity persistence based on the
 * {@code Discussion} entity and its associated primary key of type {@code UUID}.
 *
 * This interface extends {@code JpaRepository}, inheriting a standard set of data access
 * methods without requiring explicit implementation. The repository is annotated with
 * {@code @Repository} to indicate its role within the Spring framework's persistence layer.
 *
 * Key Features:
 * - Supports standard JPA repository operations such as save, findById, findAll, and delete.
 * - Automatically leverages the underlying JPA provider for database interactions.
 * - Operates on the table associated with the {@code Discussion} entity.
 */
@Repository
public interface DiscussionRepository extends JpaRepository<Discussion, UUID>, JpaSpecificationExecutor<Discussion> {
    Optional<Discussion> findByResourceIdAndResourceType(UUID resourceId, String resourceType);
    Page<Discussion> findByVisibility(String visibility, Pageable pageable);

    @Query("SELECT COUNT(t) FROM Thread t WHERE t.discussion.id = :discussionId")
    long countAllThreadsByDiscussionId(@Param("discussionId") UUID discussionId);


}
