create schema if not exists "wp2_discussion";

set schema 'wp2_discussion';

CREATE TABLE if not exists discussions (
                            id uuid PRIMARY KEY,
                            title VARCHAR(255) NOT NULL,
                            content TEXT,
                            created_by VARCHAR(50) NOT NULL,
                            created_at TIMESTAMP NOT NULL DEFAULT NOW(),
                            resource_id uuid NOT NULL,
                            resource_type VARCHAR(100),
                            visibility VARCHAR(50) NOT NULL,
                            url VARCHAR(500),
                            updated_by VARCHAR(50),
                            updated_at TIMESTAMP
);


CREATE TABLE if not exists threads (
                        id uuid PRIMARY KEY,
                        discussion_id uuid NOT NULL REFERENCES discussions(id) ON DELETE CASCADE,
                        parent_id uuid REFERENCES threads(id) ON DELETE CASCADE,
                        created_by VARCHAR(50) NOT NULL,
                        created_at TIMESTAMP NOT NULL DEFAULT NOW(),
                        modified_at TIMESTAMP NULL,
                        content TEXT NOT NULL
);

CREATE TABLE if not exists discussion_reaction (
                                     id uuid PRIMARY KEY,
                                     discussion_id uuid NOT NULL REFERENCES discussions(id) ON DELETE CASCADE,
                                     user_id VARCHAR(50) NOT NULL,
                                     reaction VARCHAR(50) NOT NULL,
                                     created_at TIMESTAMP NOT NULL DEFAULT NOW(),
                                     UNIQUE (discussion_id, user_id)
);

CREATE TABLE if not exists thread_reaction (
                                 id uuid PRIMARY KEY,
                                 thread_id uuid NOT NULL REFERENCES threads(id) ON DELETE CASCADE,
                                 user_id VARCHAR(50) NOT NULL,
                                 reaction VARCHAR(50) NOT NULL,
                                 created_at TIMESTAMP NOT NULL DEFAULT NOW(),
                                 UNIQUE (thread_id, user_id)
);
