package com.finconsgroup.itserr.marketplace.discussion.bs.enums;


/**
 * Enumeration representing discussion event types.
 *
 * <p>Supported discussions event types:</p>
 * <ul>
 *   <li>{@code CREATED} - Indicates a new discussion resource was created</li>
 *   <li>{@code UPDATED} - Indicates an existing discussion resource was modified</li>
 *   <li>{@code DELETED} - Indicates a discussion resource was removed</li>
 *   <li>{@code THREAD_CREATED} - Indicates a new thread/reply was created</li>
 * </ul>
 *
 */
public enum MessagingEventType {
    CREATED,
    UPDATED,
    DELETED,
    THREAD_CREATED
}
