package com.finconsgroup.itserr.marketplace.discussion.bs.messaging.producer;

import com.finconsgroup.itserr.marketplace.discussion.bs.dto.DiscussionDTO;
import org.springframework.lang.NonNull;

/**
 * Message Producer responsible for publishing news-related resource messages
 */
public interface ResourceProducer {

    /**
     * Publishes a message for created resource.
     *
     * @param resource the resource that was created
     */
    void publishCreatedResource(@NonNull DiscussionDTO resource);

    /**
     * Publishes a message for updated resource.
     *
     * @param resource the resource that was updated
     */
    void publishUpdatedResource(@NonNull DiscussionDTO resource);

    /**
     * Publishes a message for deleted resource.
     *
     * @param resource the resource that was deleted
     */
    void publishDeletedResource(@NonNull DiscussionDTO resource);
}
