package com.finconsgroup.itserr.marketplace.discussion.bs.messaging.dto;

import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.experimental.SuperBuilder;

import java.util.List;

/**
 * DTO that carries additional discussion-specific fields within a messaging event payload.
 * <p>
 * This object is nested inside {@link com.finconsgroup.itserr.messaging.dto.MessagingEventDto}
 * as its {@code additionalData} property, and provides extra attributes that enrich
 * the discussion resource event.
 * </p>
 *
 * <ul>
 *   <li>{@code content} – textual content of the discussion</li>
 *   <li>{@code imageUrl} – URL to an image attached to the discussion</li>
 *   <li>{@code visibility} – visibility level of the discussion (e.g. {@code public}, {@code private})</li>
 * </ul>
 */
@SuperBuilder
@Data
@NoArgsConstructor
public class DiscussionMessagingAdditionalDataDto {

    /**
     * The textual body/content of the discussion.
     */
    private String content;

    /**
     * URL pointing to an image associated with the discussion.
     */
    private String imageUrl;

    /**
     * Visibility of the discussion, e.g. "public" or "private".
     */
    private String visibility;

    /**
     * Users to be notified (if applicable).
     */
    private List<String> usersToBeNotified;
}
