package com.finconsgroup.itserr.marketplace.discussion.bs.mapper;

import com.finconsgroup.itserr.marketplace.discussion.bs.bean.DiscussionThreadDetails;
import com.finconsgroup.itserr.marketplace.discussion.bs.dto.DiscussionDTO;
import com.finconsgroup.itserr.marketplace.discussion.bs.dto.ThreadDTO;
import com.finconsgroup.itserr.marketplace.discussion.bs.messaging.dto.DiscussionMessagingAdditionalDataDto;
import com.finconsgroup.itserr.marketplace.discussion.bs.messaging.dto.DiscussionThreadMessagingAdditionalDataDto;
import com.finconsgroup.itserr.messaging.dto.MessagingEventDto;
import io.micrometer.common.util.StringUtils;
import org.mapstruct.Mapper;
import org.mapstruct.Mapping;
import org.mapstruct.Named;

import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.Set;
import java.util.UUID;

import static com.finconsgroup.itserr.marketplace.discussion.bs.utils.Constants.DISCUSSION_THREAD_MESSAGING_NAME;

@Mapper(componentModel = "spring")
public interface EventToDiscussionMapper {

    @Mapping(source = ".", target = "title", qualifiedByName = "mapTitle")
    @Mapping(source = "additionalData.content", target = "content")
    @Mapping(source = "user.username", target = "createdBy")
    @Mapping(source = "id", target = "resourceId", qualifiedByName = "stringToUuid")
    @Mapping(source = "additionalData.imageUrl", target = "url")
    @Mapping(source = "additionalData.visibility", target = "visibility", defaultValue = "public")
    @Mapping(expression = "java(java.time.Instant.now())", target = "createdAt")
    @Mapping(ignore = true, target = "resourceType")
    @Mapping(ignore = true, target = "id")
    @Mapping(ignore = true, target = "threads")
    @Mapping(ignore = true, target = "reactions")
    @Mapping(ignore = true, target = "reactionCounts")
    @Mapping(ignore = true, target = "userInfoDTO")
    @Mapping(ignore = true, target = "threadsCount")
    @Mapping(ignore = true, target = "updatedBy")
    @Mapping(ignore = true, target = "updatedAt")
    DiscussionDTO toDiscussionDTO(MessagingEventDto<DiscussionMessagingAdditionalDataDto> dto);

    @Named("mapTitle")
    default String mapTitle(MessagingEventDto<DiscussionMessagingAdditionalDataDto> dto) {
        if (StringUtils.isBlank(dto.getTitle())) {
            return dto.getName();
        }
        return dto.getTitle();
    }

    @Mapping(source = "thread.id", target = "id")
    @Mapping(source = "thread.createdAt", target = "timestamp", qualifiedByName = "localDateTimeToInstant")
    @Mapping(source = "discussion.id", target = "discussionId")
    @Mapping(source = "discussion.title", target = "discussionTitle")
    @Mapping(source = "discussion.resourceId", target = "discussionResourceId")
    @Mapping(source = "discussion.resourceType", target = "discussionResourceType")
    @Mapping(constant = DISCUSSION_THREAD_MESSAGING_NAME, target = "name")
    DiscussionThreadDetails toDiscussionThreadDetails(ThreadDTO thread, DiscussionDTO discussion, Set<String> usersToNotify);

    @Mapping(source = "discussionTitle", target = "title")
    @Mapping(target = "category", ignore = true)
    @Mapping(target = "user", ignore = true)
    @Mapping(target = "message", ignore = true)
    @Mapping(target = "status", ignore = true)
    @Mapping(target = "additionalData", ignore = true)
    MessagingEventDto<DiscussionThreadMessagingAdditionalDataDto> toMessagingEventDto(DiscussionThreadDetails discussionThreadDetails);

    @Mapping(target = "category", source = "resourceType")
    @Mapping(target = "user", ignore = true)
    @Mapping(target = "name", ignore = true)
    @Mapping(target = "timestamp", ignore = true)
    @Mapping(target = "message", ignore = true)
    @Mapping(target = "status", ignore = true)
    @Mapping(target = "additionalData", ignore = true)
    MessagingEventDto<DiscussionMessagingAdditionalDataDto> toMessagingEventDto(DiscussionDTO discussion);

    @Named("localDateTimeToInstant")
    default Instant localDateTimeToInstant(LocalDateTime localDateTime) {
        return localDateTime != null ? localDateTime.atZone(ZoneId.of("UTC")).toInstant() : null;
    }

    @Named("stringToUuid")
    default UUID stringToUuid(String id) {
        return id != null ? UUID.fromString(id) : null;
    }
}