package com.finconsgroup.itserr.marketplace.discussion.bs.dto;

import com.finconsgroup.itserr.marketplace.discussion.bs.enums.ReactionType;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.time.LocalDateTime;
import java.util.List;
import java.util.Map;
import java.util.UUID;

/**
 * Data Transfer Object for Thread entity.
 * This DTO is used to transfer thread data between different layers of the application.
 */
@NoArgsConstructor
@AllArgsConstructor
@Builder
@Data
public class ThreadDTO {

    /**
     * The universally unique identifier (UUID) for the thread.
     */
    private UUID id;

    /**
     * The identifier of the user who created the thread.
     */
    private String createdBy;

    /**
     * The date and time when the thread was created.
     */
    private LocalDateTime createdAt;

    /**
     * The textual content of the thread.
     */
    private String content;

    /**
     * The UUID of the parent thread (null if this is a top-level thread).
     */
    private UUID parentId;

    /**
     * List of replies to this thread.
     */
    private List<ThreadDTO> replies;

    private List<ThreadReactionDTO> reactions;

    private Map<ReactionType, Long> reactionCounts;

    private UserInfoDTO userInfoDTO;
}
