package com.finconsgroup.itserr.marketplace.discussion.bs.dto;

import com.finconsgroup.itserr.marketplace.discussion.bs.enums.ReactionType;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.time.LocalDateTime;
import java.util.UUID;

/**
 * Data Transfer Object for DiscussionReaction entity.
 * This DTO is used to transfer discussion reaction data between different layers of the application.
 */
@NoArgsConstructor
@AllArgsConstructor
@Builder
@Data
public class DiscussionReactionDTO {

    /**
     * The universally unique identifier (UUID) for the discussion reaction.
     */
    private UUID id;

    /**
     * The identifier of the user who created the reaction.
     */
    private String userId;

    /**
     * The type of reaction (LIKE, CELEBRATE, LOVE, INSIGHTFUL, CURIOUS).
     */
    private ReactionType reaction;
    /**
     * The date and time when the reaction was created.
     */
    private LocalDateTime createdAt;

    private UserInfoDTO userInfoDTO;

}
