package com.finconsgroup.itserr.marketplace.discussion.bs.config.properties;

import com.finconsgroup.itserr.messaging.consumer.handler.ConsumerMessageHandler;
import lombok.extern.slf4j.Slf4j;
import org.springframework.boot.ApplicationRunner;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

import java.util.Map;

@Slf4j
@Configuration
public class MessagingDebugConfig {

    @Bean
    ApplicationRunner checkHandlers(ApplicationContext ctx) {
        return args -> {
            Map<String, ConsumerMessageHandler> beans =
                    ctx.getBeansOfType(ConsumerMessageHandler.class);
            log.info("ConsumerMessageHandler beans: {}", beans.keySet());
        };
    }
}
