package com.finconsgroup.itserr.marketplace.discussion.bs.messaging;

import com.finconsgroup.itserr.marketplace.discussion.bs.config.properties.PiProperties;
import com.finconsgroup.itserr.marketplace.discussion.bs.enums.ResourceType;
import com.finconsgroup.itserr.marketplace.discussion.bs.service.DiscussionService;
import com.finconsgroup.itserr.messaging.consumer.AbstractResourceSubscriber;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Component;

import java.util.Objects;

@Slf4j
@Component("institutionalPageCreationSubscriber")
@RequiredArgsConstructor
public class InstitutionalPagesCreationSubscriber extends AbstractResourceSubscriber {

    private final DiscussionService discussionService;
    private final PiProperties piProperties;

    @Override
    protected void handleResource(String id, Object eventData, String eventType) {
        if (Objects.equals(eventType, piProperties.getResourceCreatedEventType())) {
            discussionService.createDiscussionFromEvent(id, eventData, ResourceType.INSTITUTIONAL_PAGE.getValue());
        }
    }
}
