package com.finconsgroup.itserr.marketplace.discussion.bs.config.properties;

import jakarta.validation.constraints.NotBlank;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.springframework.boot.context.properties.ConfigurationProperties;

@Data
@NoArgsConstructor
@AllArgsConstructor
@ConfigurationProperties(prefix = "discussion.bs.messaging.pi")
public class PiProperties {
    /**
     * Defines the name of the Spring Bean used to handle consumer-specific logic
     * within the context of PI-related messaging functionalities.
     * This property is mandatory and must not be blank.
     */
    @NotBlank
    private String consumerHandlerBeanName;
    /**
     * Represents the type of event triggered when a resource is created.
     * This property is mandatory and must not be blank.
     */
    @NotBlank
    private String resourceCreatedEventType;
}
