package com.finconsgroup.itserr.marketplace.discussion.bs.config.properties;

import jakarta.validation.constraints.NotBlank;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.springframework.boot.context.properties.ConfigurationProperties;

@Data
@NoArgsConstructor
@AllArgsConstructor
@ConfigurationProperties(prefix = "discussion.bs.messaging.events")
public class EventsProperties {
    /**
     * The name of the Spring Bean that handles consumer-specific logic for events.
     * This property is mandatory and must not be blank.
     */
    @NotBlank
    private String consumerHandlerBeanName;
    /**
     * Represents the type of event triggered when a resource is created.
     * This property is mandatory and must not be blank.
     */
    @NotBlank
    private String resourceCreatedEventType;
}
