package com.finconsgroup.itserr.marketplace.discussion.bs.client.dm;

import com.finconsgroup.itserr.marketplace.discussion.bs.dto.InputFindUserProfilesByIdsDto;
import com.finconsgroup.itserr.marketplace.discussion.bs.dto.InputFindUserProfilesByPrincipalsDto;
import com.finconsgroup.itserr.marketplace.discussion.bs.dto.OutputUserProfileDto;
import org.springframework.data.domain.Page;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

/**
 * Client interface for retrieving user profiles from a dedicated User Profile service.
 */
public interface UserProfileDmClient {
    /**
     * Finds user profiles by a set of IDs, with pagination and sorting.
     *
     * @param dto contains the list of UUIDs to fetch (single request body)
     * @param pageNumber page number (0-based)
     * @param pageSize page size
     * @param sort sorting field
     * @param direction sort direction (asc|desc)
     */
    @PostMapping("/profiles-by-ids")
    Page<OutputUserProfileDto> findAllByIds(
            @RequestBody InputFindUserProfilesByIdsDto dto,
            @RequestParam("pageNumber") int pageNumber,
            @RequestParam("pageSize") int pageSize,
            @RequestParam("sort") String sort,
            @RequestParam("direction") String direction
    );

    @PostMapping("/profiles-by-principals")
    Page<OutputUserProfileDto> findAllByPrincipals(
            @RequestBody InputFindUserProfilesByPrincipalsDto dto,
            @RequestParam("pageNumber") int pageNumber,
            @RequestParam("pageSize") int pageSize,
            @RequestParam("sort") String sort,
            @RequestParam("direction") String direction
    );
}
