package com.finconsgroup.itserr.marketplace.discussion.bs.api;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.enums.ParameterIn;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.security.SecurityRequirement;
import io.swagger.v3.oas.annotations.tags.Tag;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseStatus;

/**
 * Interface for managing REST operations on Discussion.
 *
 * <p>
 * Provides endpoints for admin perform operations on Discussion
 * </p>
 */
@Tag(
        name = "AdminApi",
        description = "API for managing discussions"
)
@SecurityRequirement(name = "BearerAuth")
public interface AdminApi {

    /**
     * Publish resource messages for all posts.
     * <p></p>
     * One of the use case would be to sync all posts with the Search index.
     */
    @Operation(
            summary = "publish resource messages for all filtered posts",
            responses = {
                    @ApiResponse(responseCode = "204", description = "No Content")
            }
    )
    @PostMapping(value = "/admin/discussions/publish")
    @ResponseStatus(HttpStatus.NO_CONTENT)
    void publishAllDiscussions(
            @Parameter(description = "Filter by resource type (optional)", in = ParameterIn.QUERY, example = "item")
            @RequestParam(value = "resourceType", required = false) String resourceType,
            @Parameter(description = "Filter by visibility (optional)", in = ParameterIn.QUERY, example = "public")
            @RequestParam(value = "visibility", required = false) String visibility
    );
}
