package com.finconsgroup.itserr.marketplace.discussion.bs.messaging;

import com.finconsgroup.itserr.marketplace.discussion.bs.config.properties.PiProperties;
import com.finconsgroup.itserr.marketplace.discussion.bs.enums.ResourceType;
import com.finconsgroup.itserr.marketplace.discussion.bs.utils.EntityAdditionalDataWrapper;
import com.finconsgroup.itserr.marketplace.discussion.bs.utils.OperationType;
import com.finconsgroup.itserr.messaging.consumer.AbstractResourceSubscriber;
import com.finconsgroup.itserr.messaging.utils.CloudEventUtil;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Component;

import java.util.Objects;

@Slf4j
@Component("institutionalPageCreationSubscriber")
@RequiredArgsConstructor
public class InstitutionalPagesCreationSubscriber extends AbstractResourceSubscriber {

    private final CreationDiscussionUtility creationDiscussionUtility;
    private final PiProperties piProperties;

    @Override
    protected void handleResource(String id, Object eventData, String eventType) {
        if (Objects.equals(eventType, piProperties.getResourceCreatedEventType())) {

            EntityAdditionalDataWrapper statusWrapper = CloudEventUtil.getObjectMapper()
                    .convertValue(eventData, EntityAdditionalDataWrapper.class);

            // Proceed only if the resource is approved and operation type is CREATE
            if (statusWrapper.getAdditionalData() != null
                    && statusWrapper.getAdditionalData().isApproved()
                    && statusWrapper.getAdditionalData().getOperationType() != null
                    && OperationType.CREATE.equals(statusWrapper.getAdditionalData().getOperationType())) {
                creationDiscussionUtility.create(id, eventData, ResourceType.INSTITUTIONAL_PAGE.getValue());
            }
        }
    }
}
