package com.finconsgroup.itserr.marketplace.audit.dm.service;

import com.finconsgroup.itserr.marketplace.audit.dm.dto.InputCreateAuditLogDto;
import com.finconsgroup.itserr.marketplace.audit.dm.dto.OutputAuditLogDto;
import com.finconsgroup.itserr.marketplace.core.web.exception.WP2ResourceNotFoundException;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.lang.NonNull;

import java.util.UUID;

/**
 * Service for handling business logic related to Audit Logs.
 * This interface provides methods to retrieve and create Audit Logs,
 *
 * <p>Example usage:
 * <pre>
 * Page<OutputAuditLogDto> Audit = AuditLogService.findAll(pageable);
 * </pre>
 * </p>
 */
public interface AuditLogService {

    /**
     * Retrieves a paginated list of all Audit Logs.
     *
     * @param pageable the pagination information
     * @return a page of OutputAuditDto representing the Audit
     */
    @NonNull
    Page<OutputAuditLogDto> findAll(@NonNull Pageable pageable);

    /**
     * Retrieves audit log by id.
     *
     * @param auditId the id of the audit log
     * @return an OutputAuditLogDto representing the audit log
     * @throws WP2ResourceNotFoundException if no audit log is found with the given id
     */
    @NonNull
    OutputAuditLogDto findById(@NonNull UUID auditId);

    /**
     * Creates new audit log using the provided input data.
     *
     * @param inputCreateAuditLogDto the input DTO containing audit log details
     */
    @NonNull
    OutputAuditLogDto create(@NonNull InputCreateAuditLogDto inputCreateAuditLogDto);

}
