/*
 * Decompiled with CFR 0.152.
 */
package com.finconsgroup.itserr.marketplace.audit.dm.dto;

import com.finconsgroup.itserr.marketplace.audit.dm.dto.InputAuditLogResourceDto;
import com.finconsgroup.itserr.marketplace.audit.dm.dto.InputAuditLogUserDto;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotBlank;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Size;
import java.time.Instant;
import java.util.Map;
import lombok.Generated;

@Schema(name="InputCreateAuditLogDto", description="DTO for creating audit log")
public class InputCreateAuditLogDto {
    @Schema(description="The source of the event, usually this represents the microservice which generated the event.", example="catalog-bs")
    @NotBlank
    @Size(max=100)
    private @NotBlank @Size(max=100) String eventSource;
    @Schema(description="The type of the event.", example="catalog-item-event-created")
    @NotBlank
    @Size(max=100)
    private @NotBlank @Size(max=100) String eventType;
    @Valid
    @NotNull
    @Schema(description="The user from User Profile whose action triggered the event.")
    private InputAuditLogUserDto user;
    @Valid
    @NotNull
    @Schema(description="The resource on which the event was triggered.")
    private InputAuditLogResourceDto resource;
    @Schema(description="The message indicating the reason for an action.", example="Approved as everything looks correct")
    @Size(max=800)
    private @Size(max=800) String eventMessage;
    @Schema(description="The additional data that was provided on the event by the source microservice", example="{\"notifyUserIds\": [\"a18b4e8f-36f2-4105-8e0e-ba0c0d7dd635\"]}")
    private Map<String, Object> eventAdditionalData;
    @NotNull
    @Schema(description="The time at which the event action was actually triggered by the user.", example="2025-08-25T11:22:33.123456Z")
    private Instant eventActionTime;
    @NotNull
    @Schema(description="The time at which the event was generated by the source microservice.", example="2025-08-25T11:23:32.123456Z")
    private Instant eventCreationTime;

    @Generated
    protected InputCreateAuditLogDto(InputCreateAuditLogDtoBuilder<?, ?> b) {
        this.eventSource = b.eventSource;
        this.eventType = b.eventType;
        this.user = b.user;
        this.resource = b.resource;
        this.eventMessage = b.eventMessage;
        this.eventAdditionalData = b.eventAdditionalData;
        this.eventActionTime = b.eventActionTime;
        this.eventCreationTime = b.eventCreationTime;
    }

    @Generated
    public static InputCreateAuditLogDtoBuilder<?, ?> builder() {
        return new InputCreateAuditLogDtoBuilderImpl();
    }

    @Generated
    public String getEventSource() {
        return this.eventSource;
    }

    @Generated
    public String getEventType() {
        return this.eventType;
    }

    @Generated
    public InputAuditLogUserDto getUser() {
        return this.user;
    }

    @Generated
    public InputAuditLogResourceDto getResource() {
        return this.resource;
    }

    @Generated
    public String getEventMessage() {
        return this.eventMessage;
    }

    @Generated
    public Map<String, Object> getEventAdditionalData() {
        return this.eventAdditionalData;
    }

    @Generated
    public Instant getEventActionTime() {
        return this.eventActionTime;
    }

    @Generated
    public Instant getEventCreationTime() {
        return this.eventCreationTime;
    }

    @Generated
    public void setEventSource(String eventSource) {
        this.eventSource = eventSource;
    }

    @Generated
    public void setEventType(String eventType) {
        this.eventType = eventType;
    }

    @Generated
    public void setUser(InputAuditLogUserDto user) {
        this.user = user;
    }

    @Generated
    public void setResource(InputAuditLogResourceDto resource) {
        this.resource = resource;
    }

    @Generated
    public void setEventMessage(String eventMessage) {
        this.eventMessage = eventMessage;
    }

    @Generated
    public void setEventAdditionalData(Map<String, Object> eventAdditionalData) {
        this.eventAdditionalData = eventAdditionalData;
    }

    @Generated
    public void setEventActionTime(Instant eventActionTime) {
        this.eventActionTime = eventActionTime;
    }

    @Generated
    public void setEventCreationTime(Instant eventCreationTime) {
        this.eventCreationTime = eventCreationTime;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof InputCreateAuditLogDto)) {
            return false;
        }
        InputCreateAuditLogDto other = (InputCreateAuditLogDto)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$eventSource = this.getEventSource();
        String other$eventSource = other.getEventSource();
        if (this$eventSource == null ? other$eventSource != null : !this$eventSource.equals(other$eventSource)) {
            return false;
        }
        String this$eventType = this.getEventType();
        String other$eventType = other.getEventType();
        if (this$eventType == null ? other$eventType != null : !this$eventType.equals(other$eventType)) {
            return false;
        }
        InputAuditLogUserDto this$user = this.getUser();
        InputAuditLogUserDto other$user = other.getUser();
        if (this$user == null ? other$user != null : !((Object)this$user).equals(other$user)) {
            return false;
        }
        InputAuditLogResourceDto this$resource = this.getResource();
        InputAuditLogResourceDto other$resource = other.getResource();
        if (this$resource == null ? other$resource != null : !((Object)this$resource).equals(other$resource)) {
            return false;
        }
        String this$eventMessage = this.getEventMessage();
        String other$eventMessage = other.getEventMessage();
        if (this$eventMessage == null ? other$eventMessage != null : !this$eventMessage.equals(other$eventMessage)) {
            return false;
        }
        Map<String, Object> this$eventAdditionalData = this.getEventAdditionalData();
        Map<String, Object> other$eventAdditionalData = other.getEventAdditionalData();
        if (this$eventAdditionalData == null ? other$eventAdditionalData != null : !((Object)this$eventAdditionalData).equals(other$eventAdditionalData)) {
            return false;
        }
        Instant this$eventActionTime = this.getEventActionTime();
        Instant other$eventActionTime = other.getEventActionTime();
        if (this$eventActionTime == null ? other$eventActionTime != null : !((Object)this$eventActionTime).equals(other$eventActionTime)) {
            return false;
        }
        Instant this$eventCreationTime = this.getEventCreationTime();
        Instant other$eventCreationTime = other.getEventCreationTime();
        return !(this$eventCreationTime == null ? other$eventCreationTime != null : !((Object)this$eventCreationTime).equals(other$eventCreationTime));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof InputCreateAuditLogDto;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $eventSource = this.getEventSource();
        result = result * 59 + ($eventSource == null ? 43 : $eventSource.hashCode());
        String $eventType = this.getEventType();
        result = result * 59 + ($eventType == null ? 43 : $eventType.hashCode());
        InputAuditLogUserDto $user = this.getUser();
        result = result * 59 + ($user == null ? 43 : ((Object)$user).hashCode());
        InputAuditLogResourceDto $resource = this.getResource();
        result = result * 59 + ($resource == null ? 43 : ((Object)$resource).hashCode());
        String $eventMessage = this.getEventMessage();
        result = result * 59 + ($eventMessage == null ? 43 : $eventMessage.hashCode());
        Map<String, Object> $eventAdditionalData = this.getEventAdditionalData();
        result = result * 59 + ($eventAdditionalData == null ? 43 : ((Object)$eventAdditionalData).hashCode());
        Instant $eventActionTime = this.getEventActionTime();
        result = result * 59 + ($eventActionTime == null ? 43 : ((Object)$eventActionTime).hashCode());
        Instant $eventCreationTime = this.getEventCreationTime();
        result = result * 59 + ($eventCreationTime == null ? 43 : ((Object)$eventCreationTime).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "InputCreateAuditLogDto(eventSource=" + this.getEventSource() + ", eventType=" + this.getEventType() + ", user=" + String.valueOf(this.getUser()) + ", resource=" + String.valueOf(this.getResource()) + ", eventMessage=" + this.getEventMessage() + ", eventAdditionalData=" + String.valueOf(this.getEventAdditionalData()) + ", eventActionTime=" + String.valueOf(this.getEventActionTime()) + ", eventCreationTime=" + String.valueOf(this.getEventCreationTime()) + ")";
    }

    @Generated
    public InputCreateAuditLogDto() {
    }

    @Generated
    public InputCreateAuditLogDto(String eventSource, String eventType, InputAuditLogUserDto user, InputAuditLogResourceDto resource, String eventMessage, Map<String, Object> eventAdditionalData, Instant eventActionTime, Instant eventCreationTime) {
        this.eventSource = eventSource;
        this.eventType = eventType;
        this.user = user;
        this.resource = resource;
        this.eventMessage = eventMessage;
        this.eventAdditionalData = eventAdditionalData;
        this.eventActionTime = eventActionTime;
        this.eventCreationTime = eventCreationTime;
    }

    @Generated
    public static abstract class InputCreateAuditLogDtoBuilder<C extends InputCreateAuditLogDto, B extends InputCreateAuditLogDtoBuilder<C, B>> {
        @Generated
        private String eventSource;
        @Generated
        private String eventType;
        @Generated
        private InputAuditLogUserDto user;
        @Generated
        private InputAuditLogResourceDto resource;
        @Generated
        private String eventMessage;
        @Generated
        private Map<String, Object> eventAdditionalData;
        @Generated
        private Instant eventActionTime;
        @Generated
        private Instant eventCreationTime;

        @Generated
        public B eventSource(String eventSource) {
            this.eventSource = eventSource;
            return this.self();
        }

        @Generated
        public B eventType(String eventType) {
            this.eventType = eventType;
            return this.self();
        }

        @Generated
        public B user(InputAuditLogUserDto user) {
            this.user = user;
            return this.self();
        }

        @Generated
        public B resource(InputAuditLogResourceDto resource) {
            this.resource = resource;
            return this.self();
        }

        @Generated
        public B eventMessage(String eventMessage) {
            this.eventMessage = eventMessage;
            return this.self();
        }

        @Generated
        public B eventAdditionalData(Map<String, Object> eventAdditionalData) {
            this.eventAdditionalData = eventAdditionalData;
            return this.self();
        }

        @Generated
        public B eventActionTime(Instant eventActionTime) {
            this.eventActionTime = eventActionTime;
            return this.self();
        }

        @Generated
        public B eventCreationTime(Instant eventCreationTime) {
            this.eventCreationTime = eventCreationTime;
            return this.self();
        }

        @Generated
        protected abstract B self();

        @Generated
        public abstract C build();

        @Generated
        public String toString() {
            return "InputCreateAuditLogDto.InputCreateAuditLogDtoBuilder(eventSource=" + this.eventSource + ", eventType=" + this.eventType + ", user=" + String.valueOf(this.user) + ", resource=" + String.valueOf(this.resource) + ", eventMessage=" + this.eventMessage + ", eventAdditionalData=" + String.valueOf(this.eventAdditionalData) + ", eventActionTime=" + String.valueOf(this.eventActionTime) + ", eventCreationTime=" + String.valueOf(this.eventCreationTime) + ")";
        }
    }

    @Generated
    private static final class InputCreateAuditLogDtoBuilderImpl
    extends InputCreateAuditLogDtoBuilder<InputCreateAuditLogDto, InputCreateAuditLogDtoBuilderImpl> {
        @Generated
        private InputCreateAuditLogDtoBuilderImpl() {
        }

        @Override
        @Generated
        protected InputCreateAuditLogDtoBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public InputCreateAuditLogDto build() {
            return new InputCreateAuditLogDto(this);
        }
    }
}

