/*
 * Decompiled with CFR 0.152.
 */
package com.finconsgroup.itserr.marketplace.audit.dm.dto;

import com.finconsgroup.itserr.marketplace.audit.dm.dto.OutputAuditLogResourceDto;
import com.finconsgroup.itserr.marketplace.audit.dm.dto.OutputAuditLogUserDto;
import io.swagger.v3.oas.annotations.media.Schema;
import java.time.Instant;
import java.util.Map;
import java.util.UUID;
import lombok.Generated;

@Schema(name="OutputAuditDto", description="DTO representing a audit in responses")
public class OutputAuditLogDto {
    @Schema(description="Unique identifier of the audit log", example="550e8400-e29b-41d4-a716-446655440000")
    private UUID id;
    @Schema(description="The source of the event, usually this represents the microservice which generated the event", example="catalog-bs")
    private String eventSource;
    @Schema(description="The type of the event.", example="catalog-item-event-created")
    private String eventType;
    @Schema(description="The user from User Profile whose action triggered the event.")
    private OutputAuditLogUserDto user;
    @Schema(description="The resource on which the event was triggered.")
    private OutputAuditLogResourceDto resource;
    @Schema(description="The message indicating the reason for an action.", example="Approved as everything looks correct")
    private String eventMessage;
    @Schema(description="The additional data that was provided on the event by the source microservice")
    private Map<String, Object> eventAdditionalData;
    @Schema(description="The time at which the event action was actually triggered by the user.", example="2025-08-25T11:22:33.123456Z")
    private Instant eventActionTime;
    @Schema(description="The time at which the event was generated by the source microservice.", example="2025-08-25T11:23:32.123456Z")
    private Instant eventCreationTime;
    @Schema(description="The creation time of the table record", example="2025-08-25T15:29:06.254836Z")
    private Instant creationTime;

    @Generated
    protected OutputAuditLogDto(OutputAuditLogDtoBuilder<?, ?> b) {
        this.id = b.id;
        this.eventSource = b.eventSource;
        this.eventType = b.eventType;
        this.user = b.user;
        this.resource = b.resource;
        this.eventMessage = b.eventMessage;
        this.eventAdditionalData = b.eventAdditionalData;
        this.eventActionTime = b.eventActionTime;
        this.eventCreationTime = b.eventCreationTime;
        this.creationTime = b.creationTime;
    }

    @Generated
    public static OutputAuditLogDtoBuilder<?, ?> builder() {
        return new OutputAuditLogDtoBuilderImpl();
    }

    @Generated
    public UUID getId() {
        return this.id;
    }

    @Generated
    public String getEventSource() {
        return this.eventSource;
    }

    @Generated
    public String getEventType() {
        return this.eventType;
    }

    @Generated
    public OutputAuditLogUserDto getUser() {
        return this.user;
    }

    @Generated
    public OutputAuditLogResourceDto getResource() {
        return this.resource;
    }

    @Generated
    public String getEventMessage() {
        return this.eventMessage;
    }

    @Generated
    public Map<String, Object> getEventAdditionalData() {
        return this.eventAdditionalData;
    }

    @Generated
    public Instant getEventActionTime() {
        return this.eventActionTime;
    }

    @Generated
    public Instant getEventCreationTime() {
        return this.eventCreationTime;
    }

    @Generated
    public Instant getCreationTime() {
        return this.creationTime;
    }

    @Generated
    public void setId(UUID id) {
        this.id = id;
    }

    @Generated
    public void setEventSource(String eventSource) {
        this.eventSource = eventSource;
    }

    @Generated
    public void setEventType(String eventType) {
        this.eventType = eventType;
    }

    @Generated
    public void setUser(OutputAuditLogUserDto user) {
        this.user = user;
    }

    @Generated
    public void setResource(OutputAuditLogResourceDto resource) {
        this.resource = resource;
    }

    @Generated
    public void setEventMessage(String eventMessage) {
        this.eventMessage = eventMessage;
    }

    @Generated
    public void setEventAdditionalData(Map<String, Object> eventAdditionalData) {
        this.eventAdditionalData = eventAdditionalData;
    }

    @Generated
    public void setEventActionTime(Instant eventActionTime) {
        this.eventActionTime = eventActionTime;
    }

    @Generated
    public void setEventCreationTime(Instant eventCreationTime) {
        this.eventCreationTime = eventCreationTime;
    }

    @Generated
    public void setCreationTime(Instant creationTime) {
        this.creationTime = creationTime;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof OutputAuditLogDto)) {
            return false;
        }
        OutputAuditLogDto other = (OutputAuditLogDto)o;
        if (!other.canEqual(this)) {
            return false;
        }
        UUID this$id = this.getId();
        UUID other$id = other.getId();
        if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
            return false;
        }
        String this$eventSource = this.getEventSource();
        String other$eventSource = other.getEventSource();
        if (this$eventSource == null ? other$eventSource != null : !this$eventSource.equals(other$eventSource)) {
            return false;
        }
        String this$eventType = this.getEventType();
        String other$eventType = other.getEventType();
        if (this$eventType == null ? other$eventType != null : !this$eventType.equals(other$eventType)) {
            return false;
        }
        OutputAuditLogUserDto this$user = this.getUser();
        OutputAuditLogUserDto other$user = other.getUser();
        if (this$user == null ? other$user != null : !((Object)this$user).equals(other$user)) {
            return false;
        }
        OutputAuditLogResourceDto this$resource = this.getResource();
        OutputAuditLogResourceDto other$resource = other.getResource();
        if (this$resource == null ? other$resource != null : !((Object)this$resource).equals(other$resource)) {
            return false;
        }
        String this$eventMessage = this.getEventMessage();
        String other$eventMessage = other.getEventMessage();
        if (this$eventMessage == null ? other$eventMessage != null : !this$eventMessage.equals(other$eventMessage)) {
            return false;
        }
        Map<String, Object> this$eventAdditionalData = this.getEventAdditionalData();
        Map<String, Object> other$eventAdditionalData = other.getEventAdditionalData();
        if (this$eventAdditionalData == null ? other$eventAdditionalData != null : !((Object)this$eventAdditionalData).equals(other$eventAdditionalData)) {
            return false;
        }
        Instant this$eventActionTime = this.getEventActionTime();
        Instant other$eventActionTime = other.getEventActionTime();
        if (this$eventActionTime == null ? other$eventActionTime != null : !((Object)this$eventActionTime).equals(other$eventActionTime)) {
            return false;
        }
        Instant this$eventCreationTime = this.getEventCreationTime();
        Instant other$eventCreationTime = other.getEventCreationTime();
        if (this$eventCreationTime == null ? other$eventCreationTime != null : !((Object)this$eventCreationTime).equals(other$eventCreationTime)) {
            return false;
        }
        Instant this$creationTime = this.getCreationTime();
        Instant other$creationTime = other.getCreationTime();
        return !(this$creationTime == null ? other$creationTime != null : !((Object)this$creationTime).equals(other$creationTime));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof OutputAuditLogDto;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        UUID $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        String $eventSource = this.getEventSource();
        result = result * 59 + ($eventSource == null ? 43 : $eventSource.hashCode());
        String $eventType = this.getEventType();
        result = result * 59 + ($eventType == null ? 43 : $eventType.hashCode());
        OutputAuditLogUserDto $user = this.getUser();
        result = result * 59 + ($user == null ? 43 : ((Object)$user).hashCode());
        OutputAuditLogResourceDto $resource = this.getResource();
        result = result * 59 + ($resource == null ? 43 : ((Object)$resource).hashCode());
        String $eventMessage = this.getEventMessage();
        result = result * 59 + ($eventMessage == null ? 43 : $eventMessage.hashCode());
        Map<String, Object> $eventAdditionalData = this.getEventAdditionalData();
        result = result * 59 + ($eventAdditionalData == null ? 43 : ((Object)$eventAdditionalData).hashCode());
        Instant $eventActionTime = this.getEventActionTime();
        result = result * 59 + ($eventActionTime == null ? 43 : ((Object)$eventActionTime).hashCode());
        Instant $eventCreationTime = this.getEventCreationTime();
        result = result * 59 + ($eventCreationTime == null ? 43 : ((Object)$eventCreationTime).hashCode());
        Instant $creationTime = this.getCreationTime();
        result = result * 59 + ($creationTime == null ? 43 : ((Object)$creationTime).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "OutputAuditLogDto(id=" + String.valueOf(this.getId()) + ", eventSource=" + this.getEventSource() + ", eventType=" + this.getEventType() + ", user=" + String.valueOf(this.getUser()) + ", resource=" + String.valueOf(this.getResource()) + ", eventMessage=" + this.getEventMessage() + ", eventAdditionalData=" + String.valueOf(this.getEventAdditionalData()) + ", eventActionTime=" + String.valueOf(this.getEventActionTime()) + ", eventCreationTime=" + String.valueOf(this.getEventCreationTime()) + ", creationTime=" + String.valueOf(this.getCreationTime()) + ")";
    }

    @Generated
    public OutputAuditLogDto() {
    }

    @Generated
    public OutputAuditLogDto(UUID id, String eventSource, String eventType, OutputAuditLogUserDto user, OutputAuditLogResourceDto resource, String eventMessage, Map<String, Object> eventAdditionalData, Instant eventActionTime, Instant eventCreationTime, Instant creationTime) {
        this.id = id;
        this.eventSource = eventSource;
        this.eventType = eventType;
        this.user = user;
        this.resource = resource;
        this.eventMessage = eventMessage;
        this.eventAdditionalData = eventAdditionalData;
        this.eventActionTime = eventActionTime;
        this.eventCreationTime = eventCreationTime;
        this.creationTime = creationTime;
    }

    @Generated
    public static abstract class OutputAuditLogDtoBuilder<C extends OutputAuditLogDto, B extends OutputAuditLogDtoBuilder<C, B>> {
        @Generated
        private UUID id;
        @Generated
        private String eventSource;
        @Generated
        private String eventType;
        @Generated
        private OutputAuditLogUserDto user;
        @Generated
        private OutputAuditLogResourceDto resource;
        @Generated
        private String eventMessage;
        @Generated
        private Map<String, Object> eventAdditionalData;
        @Generated
        private Instant eventActionTime;
        @Generated
        private Instant eventCreationTime;
        @Generated
        private Instant creationTime;

        @Generated
        public B id(UUID id) {
            this.id = id;
            return this.self();
        }

        @Generated
        public B eventSource(String eventSource) {
            this.eventSource = eventSource;
            return this.self();
        }

        @Generated
        public B eventType(String eventType) {
            this.eventType = eventType;
            return this.self();
        }

        @Generated
        public B user(OutputAuditLogUserDto user) {
            this.user = user;
            return this.self();
        }

        @Generated
        public B resource(OutputAuditLogResourceDto resource) {
            this.resource = resource;
            return this.self();
        }

        @Generated
        public B eventMessage(String eventMessage) {
            this.eventMessage = eventMessage;
            return this.self();
        }

        @Generated
        public B eventAdditionalData(Map<String, Object> eventAdditionalData) {
            this.eventAdditionalData = eventAdditionalData;
            return this.self();
        }

        @Generated
        public B eventActionTime(Instant eventActionTime) {
            this.eventActionTime = eventActionTime;
            return this.self();
        }

        @Generated
        public B eventCreationTime(Instant eventCreationTime) {
            this.eventCreationTime = eventCreationTime;
            return this.self();
        }

        @Generated
        public B creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this.self();
        }

        @Generated
        protected abstract B self();

        @Generated
        public abstract C build();

        @Generated
        public String toString() {
            return "OutputAuditLogDto.OutputAuditLogDtoBuilder(id=" + String.valueOf(this.id) + ", eventSource=" + this.eventSource + ", eventType=" + this.eventType + ", user=" + String.valueOf(this.user) + ", resource=" + String.valueOf(this.resource) + ", eventMessage=" + this.eventMessage + ", eventAdditionalData=" + String.valueOf(this.eventAdditionalData) + ", eventActionTime=" + String.valueOf(this.eventActionTime) + ", eventCreationTime=" + String.valueOf(this.eventCreationTime) + ", creationTime=" + String.valueOf(this.creationTime) + ")";
        }
    }

    @Generated
    private static final class OutputAuditLogDtoBuilderImpl
    extends OutputAuditLogDtoBuilder<OutputAuditLogDto, OutputAuditLogDtoBuilderImpl> {
        @Generated
        private OutputAuditLogDtoBuilderImpl() {
        }

        @Override
        @Generated
        protected OutputAuditLogDtoBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public OutputAuditLogDto build() {
            return new OutputAuditLogDto(this);
        }
    }
}

