package com.finconsgroup.itserr.marketplace.audit.bs.configuration.properties;

import jakarta.validation.constraints.NotBlank;
import lombok.Data;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.validation.annotation.Validated;

/**
 * Configuration properties for the AuditLog bs service.
 * <p>
 * These properties are mapped from the {@code audit.bs} prefix in the application configuration.
 */
@Data
@Validated
@ConfigurationProperties(prefix = "audit.bs")
public class AuditBsConfigurationProperties {

    /**
     * Base URL used by Swagger/OpenAPI documentation.
     * Example: {@code http://localhost:8080}
     */
    @NotBlank
    private String swaggerApiServerUrl;
}
