/*
 * Decompiled with CFR 0.152.
 */
package com.finconsgroup.itserr.marketplace.metadata.integration.mapper;

import com.finconsgroup.itserr.marketplace.metadata.integration.client.metadatadm.dto.OutputMetadataFieldDmDto;
import com.finconsgroup.itserr.marketplace.metadata.integration.client.metadatadm.dto.OutputMetadataFieldDmType;
import com.finconsgroup.itserr.marketplace.metadata.integration.mapper.FieldMapper;
import com.finconsgroup.itserr.marketplace.metadata.lib.bean.Field;
import com.finconsgroup.itserr.marketplace.metadata.lib.bean.FieldType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import org.springframework.stereotype.Component;

@Component
public class FieldMapperImpl
implements FieldMapper {
    @Override
    public Field clientFieldToField(OutputMetadataFieldDmDto src) {
        if (src == null) {
            return null;
        }
        Field.FieldBuilder field = Field.builder();
        field.validation(this.mapPattern(src.getValidation()));
        field.name(src.getName());
        field.type(this.outputMetadataFieldDmTypeToFieldType(src.getType()));
        List<String> list = src.getVocabulary();
        if (list != null) {
            field.vocabulary(new LinkedHashSet<String>(list));
        }
        field.mandatory(src.isMandatory());
        return field.build();
    }

    @Override
    public List<Field> clientFieldsToFields(Collection<OutputMetadataFieldDmDto> srcs) {
        if (srcs == null) {
            return null;
        }
        ArrayList<Field> list = new ArrayList<Field>(srcs.size());
        for (OutputMetadataFieldDmDto outputMetadataFieldDmDto : srcs) {
            list.add(this.clientFieldToField(outputMetadataFieldDmDto));
        }
        return list;
    }

    protected FieldType outputMetadataFieldDmTypeToFieldType(OutputMetadataFieldDmType outputMetadataFieldDmType) {
        if (outputMetadataFieldDmType == null) {
            return null;
        }
        return switch (outputMetadataFieldDmType) {
            case OutputMetadataFieldDmType.STRING -> FieldType.STRING;
            case OutputMetadataFieldDmType.TIME -> FieldType.TIME;
            case OutputMetadataFieldDmType.TIME_INTERVAL -> FieldType.TIME_INTERVAL;
            case OutputMetadataFieldDmType.TIMES_LISTOF -> FieldType.TIMES_LISTOF;
            case OutputMetadataFieldDmType.TEXT -> FieldType.TEXT;
            case OutputMetadataFieldDmType.BOOLEAN -> FieldType.BOOLEAN;
            case OutputMetadataFieldDmType.NUMBER -> FieldType.NUMBER;
            case OutputMetadataFieldDmType.GEO_JSON -> FieldType.GEO_JSON;
            default -> throw new IllegalArgumentException("Unexpected enum constant: " + String.valueOf((Object)outputMetadataFieldDmType));
        };
    }
}

