package com.finconsgroup.itserr.marketplace.metadata.integration.mapper;

import com.finconsgroup.itserr.marketplace.metadata.integration.client.metadatadm.dto.OutputMetadataFieldDmDto;
import com.finconsgroup.itserr.marketplace.metadata.lib.bean.Field;
import org.apache.commons.lang3.StringUtils;
import org.mapstruct.Mapper;
import org.mapstruct.Mapping;
import org.mapstruct.Named;

import java.util.Collection;
import java.util.List;
import java.util.regex.Pattern;

/**
 * Fields related mapper.
 */
@Mapper(config = MapperConfiguration.class)
public interface FieldMapper {

    /**
     * Maps a {@link OutputMetadataFieldDmDto} into a {@link Field}.
     *
     * @param src Client source field.
     * @return Mapped field.
     */
    @Mapping(target = "validation", qualifiedByName = "mapPattern")
    Field clientFieldToField(OutputMetadataFieldDmDto src);

    /**
     * Maps a collection of {@link OutputMetadataFieldDmDto} into a list of {@link Field}.
     *
     * @param srcs Client source fields.
     * @return Mapped fields.
     */
    List<Field> clientFieldsToFields(Collection<OutputMetadataFieldDmDto> srcs);

    /**
     * Maps a {@link OutputMetadataFieldDmDto#getValidation()} into a {@link Field#validation()}.
     *
     * @param pattern Pattern Regex string.
     * @return Equivalent {@link Pattern}.
     */
    @Named("mapPattern")
    default Pattern mapPattern(String pattern) {
        return StringUtils.isNotEmpty(pattern)
                ? Pattern.compile(pattern)
                : null;
    }

}
