package com.finconsgroup.itserr.marketplace.metadata.integration.client.metadatadm.exception;

import com.finconsgroup.itserr.marketplace.core.web.exception.WP2AuthenticationException;
import com.finconsgroup.itserr.marketplace.core.web.exception.WP2ResourceNotFoundException;
import feign.FeignException;
import feign.Response;
import feign.codec.ErrorDecoder;
import org.springframework.stereotype.Component;

/**
 * <p>A Feign {@link ErrorDecoder} that converts common error statuses in core-lib exceptions.</p>
 * <p>
 * This decoder will act as follows:
 * <ul>
 * <li>on {@value #HTTP_UNAUTHORIZED}, returns a {@link WP2AuthenticationException}</li>
 * <li>on {@value #HTTP_NOT_FOUND}, returns a {@link WP2ResourceNotFoundException}</li>
 * <li>otherwise, returns a regular {@link FeignException}</li>
 * </ul>
 * </p>
 */
@Component("metadataLibsIntegrationErrorDecoder")
public class MetadataLibsIntegrationErrorDecoder implements ErrorDecoder {

    private static final int HTTP_UNAUTHORIZED = 401;
    private static final int HTTP_NOT_FOUND = 404;

    @Override
    public Exception decode(
            final String methodKey,
            final Response response) {

        // Decode
        return switch (response.status()) {
            case HTTP_UNAUTHORIZED -> new WP2AuthenticationException();
            case HTTP_NOT_FOUND -> new WP2ResourceNotFoundException("Resource not found");
            default -> FeignException.errorStatus(methodKey, response);
        };

    }

}
