/*
 * Decompiled with CFR 0.152.
 */
package org.finconsgroup.itserr.criterion.security.aspect;

import jakarta.servlet.http.HttpServletRequest;
import lombok.Generated;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.reflect.MethodSignature;
import org.finconsgroup.itserr.criterion.common.exception.UnauthorizedException;
import org.finconsgroup.itserr.criterion.security.annotation.ExternalAuthCheck;
import org.finconsgroup.itserr.criterion.security.config.ExternalAuthProperties;
import org.finconsgroup.itserr.criterion.security.dto.AuthorizationRequest;
import org.finconsgroup.itserr.criterion.security.service.ExternalAuthService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

@Aspect
public class ExternalAuthAspect {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ExternalAuthAspect.class);
    private final ExternalAuthService externalAuthService;
    private final ExternalAuthProperties properties;

    public ExternalAuthAspect(ExternalAuthService externalAuthService, ExternalAuthProperties properties) {
        this.externalAuthService = externalAuthService;
        this.properties = properties;
    }

    @Around(value="@annotation(externalAuthCheck)")
    public Object checkAuthorizationOnMethod(ProceedingJoinPoint joinPoint, ExternalAuthCheck externalAuthCheck) throws Throwable {
        return this.doCheck(joinPoint, externalAuthCheck);
    }

    @Around(value="@within(externalAuthCheck) && !@annotation(org.finconsgroup.itserr.criterion.security.annotation.ExternalAuthCheck)")
    public Object checkAuthorizationOnClass(ProceedingJoinPoint joinPoint, ExternalAuthCheck externalAuthCheck) throws Throwable {
        return this.doCheck(joinPoint, externalAuthCheck);
    }

    private Object doCheck(ProceedingJoinPoint joinPoint, ExternalAuthCheck externalAuthCheck) throws Throwable {
        if (!this.properties.isEnabled()) {
            log.debug("External auth check is disabled globally, proceeding without check");
            return joinPoint.proceed();
        }
        HttpServletRequest request = this.getCurrentRequest();
        if (this.isValidInternalCall(request)) {
            log.debug("Valid internal call detected, skipping external auth check");
            return joinPoint.proceed();
        }
        AuthorizationRequest authRequest = this.buildAuthRequest(request, joinPoint);
        log.debug("External call - checking authorization for {} {}", (Object)authRequest.getHttpMethod(), (Object)authRequest.getRequestUri());
        boolean isAuthorized = this.externalAuthService.checkAuthorization(externalAuthCheck.authEndpoint(), authRequest);
        if (!isAuthorized) {
            log.warn("Authorization DENIED for {} {} from {}", new Object[]{authRequest.getHttpMethod(), authRequest.getRequestUri(), authRequest.getRemoteAddress()});
            throw new UnauthorizedException(externalAuthCheck.message());
        }
        log.debug("Authorization GRANTED for {} {}", (Object)authRequest.getHttpMethod(), (Object)authRequest.getRequestUri());
        return joinPoint.proceed();
    }

    private boolean isValidInternalCall(HttpServletRequest request) {
        if (request == null) {
            return false;
        }
        ExternalAuthProperties.InternalAuthProperties internalConfig = this.properties.getInternal();
        if (!internalConfig.isConfigured()) {
            return false;
        }
        String internalAuthHeader = request.getHeader(internalConfig.getHeaderName());
        if (internalAuthHeader == null || internalAuthHeader.isEmpty()) {
            return false;
        }
        boolean isValid = internalConfig.getSecret().equals(internalAuthHeader);
        if (!isValid) {
            log.warn("Invalid internal auth header received - possible security breach attempt!");
        }
        return isValid;
    }

    private HttpServletRequest getCurrentRequest() {
        ServletRequestAttributes attrs = (ServletRequestAttributes)RequestContextHolder.getRequestAttributes();
        return attrs != null ? attrs.getRequest() : null;
    }

    private AuthorizationRequest buildAuthRequest(HttpServletRequest request, ProceedingJoinPoint joinPoint) {
        MethodSignature signature = (MethodSignature)joinPoint.getSignature();
        AuthorizationRequest.AuthorizationRequestBuilder builder = AuthorizationRequest.builder().targetMethod(signature.getMethod().getName()).targetClass(signature.getDeclaringTypeName());
        if (request != null) {
            builder.authorizationHeader(request.getHeader("Authorization")).requestUri(request.getRequestURI()).httpMethod(request.getMethod()).remoteAddress(this.getClientIpAddress(request)).userAgent(request.getHeader("User-Agent")).correlationId(request.getHeader("X-Correlation-ID"));
        }
        return builder.build();
    }

    private String getClientIpAddress(HttpServletRequest request) {
        String xForwardedFor = request.getHeader("X-Forwarded-For");
        if (xForwardedFor != null && !xForwardedFor.isEmpty()) {
            return xForwardedFor.split(",")[0].trim();
        }
        return request.getRemoteAddr();
    }
}

