/*
 * Decompiled with CFR 0.152.
 */
package org.finconsgroup.itserr.criterion.security.config;

import java.time.Duration;
import lombok.Generated;
import org.springframework.boot.context.properties.ConfigurationProperties;

@ConfigurationProperties(prefix="wp3.external-auth")
public class ExternalAuthProperties {
    private boolean enabled = true;
    private String url = "http://localhost:8081/api/authorize";
    private Duration connectTimeout = Duration.ofSeconds(5L);
    private Duration readTimeout = Duration.ofSeconds(5L);
    private boolean failOpen = false;
    private InternalAuthProperties internal = new InternalAuthProperties();
    private RetryProperties retry = new RetryProperties();
    private CircuitBreakerProperties circuitBreaker = new CircuitBreakerProperties();

    @Generated
    public ExternalAuthProperties() {
    }

    @Generated
    public boolean isEnabled() {
        return this.enabled;
    }

    @Generated
    public String getUrl() {
        return this.url;
    }

    @Generated
    public Duration getConnectTimeout() {
        return this.connectTimeout;
    }

    @Generated
    public Duration getReadTimeout() {
        return this.readTimeout;
    }

    @Generated
    public boolean isFailOpen() {
        return this.failOpen;
    }

    @Generated
    public InternalAuthProperties getInternal() {
        return this.internal;
    }

    @Generated
    public RetryProperties getRetry() {
        return this.retry;
    }

    @Generated
    public CircuitBreakerProperties getCircuitBreaker() {
        return this.circuitBreaker;
    }

    @Generated
    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    @Generated
    public void setUrl(String url) {
        this.url = url;
    }

    @Generated
    public void setConnectTimeout(Duration connectTimeout) {
        this.connectTimeout = connectTimeout;
    }

    @Generated
    public void setReadTimeout(Duration readTimeout) {
        this.readTimeout = readTimeout;
    }

    @Generated
    public void setFailOpen(boolean failOpen) {
        this.failOpen = failOpen;
    }

    @Generated
    public void setInternal(InternalAuthProperties internal) {
        this.internal = internal;
    }

    @Generated
    public void setRetry(RetryProperties retry) {
        this.retry = retry;
    }

    @Generated
    public void setCircuitBreaker(CircuitBreakerProperties circuitBreaker) {
        this.circuitBreaker = circuitBreaker;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ExternalAuthProperties)) {
            return false;
        }
        ExternalAuthProperties other = (ExternalAuthProperties)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isEnabled() != other.isEnabled()) {
            return false;
        }
        if (this.isFailOpen() != other.isFailOpen()) {
            return false;
        }
        String this$url = this.getUrl();
        String other$url = other.getUrl();
        if (this$url == null ? other$url != null : !this$url.equals(other$url)) {
            return false;
        }
        Duration this$connectTimeout = this.getConnectTimeout();
        Duration other$connectTimeout = other.getConnectTimeout();
        if (this$connectTimeout == null ? other$connectTimeout != null : !((Object)this$connectTimeout).equals(other$connectTimeout)) {
            return false;
        }
        Duration this$readTimeout = this.getReadTimeout();
        Duration other$readTimeout = other.getReadTimeout();
        if (this$readTimeout == null ? other$readTimeout != null : !((Object)this$readTimeout).equals(other$readTimeout)) {
            return false;
        }
        InternalAuthProperties this$internal = this.getInternal();
        InternalAuthProperties other$internal = other.getInternal();
        if (this$internal == null ? other$internal != null : !((Object)this$internal).equals(other$internal)) {
            return false;
        }
        RetryProperties this$retry = this.getRetry();
        RetryProperties other$retry = other.getRetry();
        if (this$retry == null ? other$retry != null : !((Object)this$retry).equals(other$retry)) {
            return false;
        }
        CircuitBreakerProperties this$circuitBreaker = this.getCircuitBreaker();
        CircuitBreakerProperties other$circuitBreaker = other.getCircuitBreaker();
        return !(this$circuitBreaker == null ? other$circuitBreaker != null : !((Object)this$circuitBreaker).equals(other$circuitBreaker));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ExternalAuthProperties;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isEnabled() ? 79 : 97);
        result = result * 59 + (this.isFailOpen() ? 79 : 97);
        String $url = this.getUrl();
        result = result * 59 + ($url == null ? 43 : $url.hashCode());
        Duration $connectTimeout = this.getConnectTimeout();
        result = result * 59 + ($connectTimeout == null ? 43 : ((Object)$connectTimeout).hashCode());
        Duration $readTimeout = this.getReadTimeout();
        result = result * 59 + ($readTimeout == null ? 43 : ((Object)$readTimeout).hashCode());
        InternalAuthProperties $internal = this.getInternal();
        result = result * 59 + ($internal == null ? 43 : ((Object)$internal).hashCode());
        RetryProperties $retry = this.getRetry();
        result = result * 59 + ($retry == null ? 43 : ((Object)$retry).hashCode());
        CircuitBreakerProperties $circuitBreaker = this.getCircuitBreaker();
        result = result * 59 + ($circuitBreaker == null ? 43 : ((Object)$circuitBreaker).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "ExternalAuthProperties(enabled=" + this.isEnabled() + ", url=" + this.getUrl() + ", connectTimeout=" + String.valueOf(this.getConnectTimeout()) + ", readTimeout=" + String.valueOf(this.getReadTimeout()) + ", failOpen=" + this.isFailOpen() + ", internal=" + String.valueOf(this.getInternal()) + ", retry=" + String.valueOf(this.getRetry()) + ", circuitBreaker=" + String.valueOf(this.getCircuitBreaker()) + ")";
    }

    public static class InternalAuthProperties {
        private boolean enabled = true;
        private String headerName = "X-Internal-Auth";
        private String secret;

        public boolean isConfigured() {
            return this.enabled && this.secret != null && !this.secret.isEmpty();
        }

        @Generated
        public InternalAuthProperties() {
        }

        @Generated
        public boolean isEnabled() {
            return this.enabled;
        }

        @Generated
        public String getHeaderName() {
            return this.headerName;
        }

        @Generated
        public String getSecret() {
            return this.secret;
        }

        @Generated
        public void setEnabled(boolean enabled) {
            this.enabled = enabled;
        }

        @Generated
        public void setHeaderName(String headerName) {
            this.headerName = headerName;
        }

        @Generated
        public void setSecret(String secret) {
            this.secret = secret;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof InternalAuthProperties)) {
                return false;
            }
            InternalAuthProperties other = (InternalAuthProperties)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.isEnabled() != other.isEnabled()) {
                return false;
            }
            String this$headerName = this.getHeaderName();
            String other$headerName = other.getHeaderName();
            if (this$headerName == null ? other$headerName != null : !this$headerName.equals(other$headerName)) {
                return false;
            }
            String this$secret = this.getSecret();
            String other$secret = other.getSecret();
            return !(this$secret == null ? other$secret != null : !this$secret.equals(other$secret));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof InternalAuthProperties;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + (this.isEnabled() ? 79 : 97);
            String $headerName = this.getHeaderName();
            result = result * 59 + ($headerName == null ? 43 : $headerName.hashCode());
            String $secret = this.getSecret();
            result = result * 59 + ($secret == null ? 43 : $secret.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "ExternalAuthProperties.InternalAuthProperties(enabled=" + this.isEnabled() + ", headerName=" + this.getHeaderName() + ", secret=" + this.getSecret() + ")";
        }
    }

    public static class RetryProperties {
        private boolean enabled = true;
        private int maxAttempts = 3;
        private Duration waitDuration = Duration.ofSeconds(1L);
        private double multiplier = 2.0;
        private Duration maxWaitDuration = Duration.ofSeconds(10L);

        @Generated
        public RetryProperties() {
        }

        @Generated
        public boolean isEnabled() {
            return this.enabled;
        }

        @Generated
        public int getMaxAttempts() {
            return this.maxAttempts;
        }

        @Generated
        public Duration getWaitDuration() {
            return this.waitDuration;
        }

        @Generated
        public double getMultiplier() {
            return this.multiplier;
        }

        @Generated
        public Duration getMaxWaitDuration() {
            return this.maxWaitDuration;
        }

        @Generated
        public void setEnabled(boolean enabled) {
            this.enabled = enabled;
        }

        @Generated
        public void setMaxAttempts(int maxAttempts) {
            this.maxAttempts = maxAttempts;
        }

        @Generated
        public void setWaitDuration(Duration waitDuration) {
            this.waitDuration = waitDuration;
        }

        @Generated
        public void setMultiplier(double multiplier) {
            this.multiplier = multiplier;
        }

        @Generated
        public void setMaxWaitDuration(Duration maxWaitDuration) {
            this.maxWaitDuration = maxWaitDuration;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof RetryProperties)) {
                return false;
            }
            RetryProperties other = (RetryProperties)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.isEnabled() != other.isEnabled()) {
                return false;
            }
            if (this.getMaxAttempts() != other.getMaxAttempts()) {
                return false;
            }
            if (Double.compare(this.getMultiplier(), other.getMultiplier()) != 0) {
                return false;
            }
            Duration this$waitDuration = this.getWaitDuration();
            Duration other$waitDuration = other.getWaitDuration();
            if (this$waitDuration == null ? other$waitDuration != null : !((Object)this$waitDuration).equals(other$waitDuration)) {
                return false;
            }
            Duration this$maxWaitDuration = this.getMaxWaitDuration();
            Duration other$maxWaitDuration = other.getMaxWaitDuration();
            return !(this$maxWaitDuration == null ? other$maxWaitDuration != null : !((Object)this$maxWaitDuration).equals(other$maxWaitDuration));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof RetryProperties;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + (this.isEnabled() ? 79 : 97);
            result = result * 59 + this.getMaxAttempts();
            long $multiplier = Double.doubleToLongBits(this.getMultiplier());
            result = result * 59 + (int)($multiplier >>> 32 ^ $multiplier);
            Duration $waitDuration = this.getWaitDuration();
            result = result * 59 + ($waitDuration == null ? 43 : ((Object)$waitDuration).hashCode());
            Duration $maxWaitDuration = this.getMaxWaitDuration();
            result = result * 59 + ($maxWaitDuration == null ? 43 : ((Object)$maxWaitDuration).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "ExternalAuthProperties.RetryProperties(enabled=" + this.isEnabled() + ", maxAttempts=" + this.getMaxAttempts() + ", waitDuration=" + String.valueOf(this.getWaitDuration()) + ", multiplier=" + this.getMultiplier() + ", maxWaitDuration=" + String.valueOf(this.getMaxWaitDuration()) + ")";
        }
    }

    public static class CircuitBreakerProperties {
        private boolean enabled = true;
        private float failureRateThreshold = 50.0f;
        private Duration waitDurationInOpenState = Duration.ofSeconds(30L);
        private int permittedNumberOfCallsInHalfOpenState = 3;
        private int slidingWindowSize = 10;
        private int minimumNumberOfCalls = 5;

        @Generated
        public CircuitBreakerProperties() {
        }

        @Generated
        public boolean isEnabled() {
            return this.enabled;
        }

        @Generated
        public float getFailureRateThreshold() {
            return this.failureRateThreshold;
        }

        @Generated
        public Duration getWaitDurationInOpenState() {
            return this.waitDurationInOpenState;
        }

        @Generated
        public int getPermittedNumberOfCallsInHalfOpenState() {
            return this.permittedNumberOfCallsInHalfOpenState;
        }

        @Generated
        public int getSlidingWindowSize() {
            return this.slidingWindowSize;
        }

        @Generated
        public int getMinimumNumberOfCalls() {
            return this.minimumNumberOfCalls;
        }

        @Generated
        public void setEnabled(boolean enabled) {
            this.enabled = enabled;
        }

        @Generated
        public void setFailureRateThreshold(float failureRateThreshold) {
            this.failureRateThreshold = failureRateThreshold;
        }

        @Generated
        public void setWaitDurationInOpenState(Duration waitDurationInOpenState) {
            this.waitDurationInOpenState = waitDurationInOpenState;
        }

        @Generated
        public void setPermittedNumberOfCallsInHalfOpenState(int permittedNumberOfCallsInHalfOpenState) {
            this.permittedNumberOfCallsInHalfOpenState = permittedNumberOfCallsInHalfOpenState;
        }

        @Generated
        public void setSlidingWindowSize(int slidingWindowSize) {
            this.slidingWindowSize = slidingWindowSize;
        }

        @Generated
        public void setMinimumNumberOfCalls(int minimumNumberOfCalls) {
            this.minimumNumberOfCalls = minimumNumberOfCalls;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof CircuitBreakerProperties)) {
                return false;
            }
            CircuitBreakerProperties other = (CircuitBreakerProperties)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.isEnabled() != other.isEnabled()) {
                return false;
            }
            if (Float.compare(this.getFailureRateThreshold(), other.getFailureRateThreshold()) != 0) {
                return false;
            }
            if (this.getPermittedNumberOfCallsInHalfOpenState() != other.getPermittedNumberOfCallsInHalfOpenState()) {
                return false;
            }
            if (this.getSlidingWindowSize() != other.getSlidingWindowSize()) {
                return false;
            }
            if (this.getMinimumNumberOfCalls() != other.getMinimumNumberOfCalls()) {
                return false;
            }
            Duration this$waitDurationInOpenState = this.getWaitDurationInOpenState();
            Duration other$waitDurationInOpenState = other.getWaitDurationInOpenState();
            return !(this$waitDurationInOpenState == null ? other$waitDurationInOpenState != null : !((Object)this$waitDurationInOpenState).equals(other$waitDurationInOpenState));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof CircuitBreakerProperties;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + (this.isEnabled() ? 79 : 97);
            result = result * 59 + Float.floatToIntBits(this.getFailureRateThreshold());
            result = result * 59 + this.getPermittedNumberOfCallsInHalfOpenState();
            result = result * 59 + this.getSlidingWindowSize();
            result = result * 59 + this.getMinimumNumberOfCalls();
            Duration $waitDurationInOpenState = this.getWaitDurationInOpenState();
            result = result * 59 + ($waitDurationInOpenState == null ? 43 : ((Object)$waitDurationInOpenState).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "ExternalAuthProperties.CircuitBreakerProperties(enabled=" + this.isEnabled() + ", failureRateThreshold=" + this.getFailureRateThreshold() + ", waitDurationInOpenState=" + String.valueOf(this.getWaitDurationInOpenState()) + ", permittedNumberOfCallsInHalfOpenState=" + this.getPermittedNumberOfCallsInHalfOpenState() + ", slidingWindowSize=" + this.getSlidingWindowSize() + ", minimumNumberOfCalls=" + this.getMinimumNumberOfCalls() + ")";
        }
    }
}

