package org.finconsgroup.itserr.criterion.common.dto;

import io.swagger.v3.oas.annotations.media.Schema;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.time.Instant;

@Schema(description = "Generic message response")
@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
public class MessageResponseDto {

    @Schema(description = "Response message", example = "Operation completed successfully")
    private String message;

    @Schema(description = "Success flag", example = "true")
    private Boolean success;

    @Schema(description = "Timestamp when the message was created", example = "2025-11-19T10:30:00Z")
    private final Instant messageTimestamp = Instant.now();

}