package org.finconsgroup.itserr.criterion.common.dto;

import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.time.Instant;
import java.time.LocalDateTime;
import java.util.Map;

@Schema(description = "Error response DTO")
@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
public class ErrorResponseDto {

    @Schema(description = "Error code", example = "400")
    private Integer errorCode;

    @Schema(description = "Map of error messages", example = "{\"email\": \"Email is required\"}")
    private Map<String, String> errorMessages;

    @Schema(description = "API path that was called", example = "/api/v1/user/register")
    private String path;

    @Schema(description = "Exception event time", example = "2025-11-19T14:30:00Z")
    @Builder.Default
    private Instant timestamp = Instant.now();

}